import java.util.Hashtable;
import javax.swing.*;
import javax.swing.table.*;

/* Ez a pelda azt hivatott bemutatni, hogyan lehet Prolog-kodot 
   beagyazni Java-programba. 
   
   Az elso peldan bemutatott programhoz illesztunk Java-ban keszitett
   grafikus feluletet. */

class GrafikusFelulet extends JFrame implements java.awt.event.ActionListener {
   private String[] processzorok = {"P","pentiumIII750MHz",
                        "pentiumIII1GHz",
                        "pentiumIV2GHz",
                        "pentiumIV3GHz",
                        "celeron750MHz",
                        "celeronIII1GHz",
                        "celeronIV2GHz",
                        "celeronIV3GHz",
                        "amd64bit3GHz" };
   private String[] alaplapok = {"A","amdABC", "intelXYZ" };
   private String[] memoriak = {"Me","ddr128","ddr256","ddr512","ddr1024"};
   private String[] dobozok = {"D","kisdoboz","kozepesdoboz","oriasdoboz"};
   private String[] billentyuzetek = {"B","multimediasbillentyuzet", "hajtogathatobillentyuzet",
                                      "hagyomanyosbillentyuzet"};
   private String[] monitorok = { "Mo","crt15","crt17","lcd14","lcd17"};
   private String[] oprendszerek = { "O", "suseLinux","windowsXP" };
  

   private JComboBox procv,alapv,memov,dobozv,billv,monitorv,oprv;
   
   private JTextField kicsoda; 
   private JButton lekerdez;
   private JTextArea valasz;
   private boolean[] b;
   private JTable tabla ;
   public GrafikusFelulet() {
     super();
     setBounds(0,0,500,450);
     setTitle("Szamitogep konfigurator");
     setDefaultCloseOperation(DISPOSE_ON_CLOSE);
     java.awt.Container felulet = getContentPane();
     felulet.setLayout(null);

     JLabel l1 = new JLabel("Processzor: ");
     l1.setBounds(10,20,200,20);
     felulet.add(l1);
     procv = new JComboBox(processzorok);
     procv.setBounds(220,20,200,18);
     felulet.add(procv);

     l1 = new JLabel("Alaplap: ");
     l1.setBounds(10,40,200,20);
     felulet.add(l1);
     alapv = new JComboBox(alaplapok);
     alapv.setBounds(220,40,200,18);
     felulet.add(alapv);

     l1 = new JLabel("Memoria: ");
     l1.setBounds(10,60,200,20);
     felulet.add(l1);
     memov = new JComboBox(memoriak);
     memov.setBounds(220,60,200,18);
     felulet.add(memov);

     l1 = new JLabel("Doboz: ");
     l1.setBounds(10,80,200,20);
     felulet.add(l1);
     dobozv = new JComboBox(dobozok);
     dobozv.setBounds(220,80,200,18);
     felulet.add(dobozv);

     l1 = new JLabel("Billentyuzet: ");
     l1.setBounds(10,100,200,20);
     felulet.add(l1);
     billv = new JComboBox(billentyuzetek);
     billv.setBounds(220,100,200,18);
     felulet.add(billv);

     l1 = new JLabel("Monitor: ");
     l1.setBounds(10,120,200,20);
     felulet.add(l1);
     monitorv = new JComboBox(monitorok);
     monitorv.setBounds(220,120,200,18);
     felulet.add(monitorv);

     l1 = new JLabel("Opercis rendszer: ");
     l1.setBounds(10,140,200,20);
     felulet.add(l1);
     oprv = new JComboBox(oprendszerek);
     oprv.setBounds(220,140,200,18);
     felulet.add(oprv);
    
     lekerdez=new JButton("Mutat");
     lekerdez.setBounds(270,180,150,20);
     felulet.add(lekerdez);
     lekerdez.addActionListener(this);
    
     tabla = new JTable();
     JScrollPane p = new JScrollPane(tabla);
     p.setBounds(10,220,480,200);
     felulet.add(p);

   } 
  public void actionPerformed(java.awt.event.ActionEvent e) {
     String allapot =  ""; /* ezek a klozok a konkret allapothoz tartoznak */
     
     String query = "szamitogep("+(String)procv.getSelectedItem()+","
       +(String)memov.getSelectedItem()+","+(String)alapv.getSelectedItem()+","
       +(String)dobozv.getSelectedItem()+","+(String)billv.getSelectedItem()+","
       +(String)monitorv.getSelectedItem()+","+(String)oprv.getSelectedItem()+")";
     System.out.println(query);
     String r=Pelda5.run(Pelda5.program0,query);

     System.out.println(r);
     int valaszszam = Pelda5.answerAmount(r,"szamitogep");
     String[][] adatok = new String[valaszszam][7]; 
     
     for (int i=0; i<valaszszam; i++) { 
         for (int j=0; j<7; j++) {
             adatok[i][j]=Pelda5.processResult(r,"szamitogep",i+1,j+1);
         }
     }

     String[] fejlec = {"Processzor","Memria","Alaplap","Doboz","Billentyzet","Monitor","Op.rendsz."};
     tabla.setModel(new DefaultTableModel(adatok,fejlec));
     tabla.setAutoResizeMode(JTable.AUTO_RESIZE_OFF);
     tabla.createDefaultColumnsFromModel();
     
    
   }        
}

public class Pelda5 {
        
        protected static String program0=
                        "intelprocesszor(pentiumIII750MHz). "+
                        "intelprocesszor(pentiumIII1GHz).   "+
                        "intelprocesszor(pentiumIV2GHz).    "+
                        "intelprocesszor(pentiumIV3GHz).    "+
                        "intelprocesszor(celeron750MHz).    "+
                        "intelprocesszor(celeronIII1GHz).   "+
                        "intelprocesszor(celeronIV2GHz).    "+
                        "intelprocesszor(celeronIV3GHz).    "+
                        "processzor(X) :- intelprocesszor(X)."+
                        "processzor(amd64bit3GHz).     "+
                        "memoria(ddr128).   "+
                        "memoria(ddr256).   "+
                        "memoria(ddr512).   "+
                        "memoria(ddr1024).  "+
                        "alaplap(intelXYZ). "+
                        "alaplap(amdABC).  "+
                        "haz(kisdoboz).     "+
                        "haz(kozepesdoboz). "+
                        "haz(oriasdoboz).   "+
                        "usbbillcsat(kisdoboz).     "+
                        "usbbillcsat(kozepesdoboz). "+
                        "usbbillcsat(oriasdoboz).   "+
                        "ps2billcsat(oriasdoboz).   "+
                        "billentyuzet(multimediasbillentyuzet).  "+
                        "billentyuzet(hajtogathatobillentyuzet). "+
                        "billentyuzet(hagyomanyosbillentyuzet).  "+
                        "usbcsat(multimediasbillentyuzet).  "+
                        "usbcsat(hajtogathatobillentyuzet). "+
                        "ps2csat(hagyomanyosbillentyuzet). "+
                        "monitor(crt15). "+
                        "monitor(crt17). "+
                        "monitor(lcd14). "+
                        "monitor(lcd17). "+
                        "oprendszer(suseLinux). "+
                        "oprendszer(windowsXP). "+    
                        "szamitogep(P,Memoria,A,H,B,Monitor,O) :- "+
                        "  processzor(P), memoria(Memoria), alaplap(A), haz(H), oprendszer(O),"+
                        "  procalaplap(P,A), alaplaphaz(A,H), billhaz(B,H), "+
                        "  oprproc(O,P), alaplapmemoria(A,Memoria), monitor(Monitor)."+
                        "oprproc(suseLinux,P) :- processzor(P)."+
                        "oprproc(windowsXP,P) :- intelprocesszor(P)."+
                        "procalaplap(amd64bit3GHz,amdABC). "+
                        "procalaplap(P,intelXYZ) :- intelprocesszor(P).  "+                
                        "alaplaphaz(A,oriasdoboz) :- alaplap(A). "+
                        "alaplaphaz(intelXYZ,kozepesdoboz). "+   
                        "alaplaphaz(intelXYZ,kisdoboz). "+  
                        "billhaz(B,H) :- billentyuzet(B), haz(H), usbbillcsat(H), usbcsat(B)."+
                        "billhaz(B,H) :- billentyuzet(B), haz(H), ps2billcsat(H), ps2csat(B)."+   
                        "alaplapmemoria(intelXYZ,M) :- memoria(M). "+
                        "alaplapmemoria(amdABC,ddr1024)."+
                        "alaplapmemoria(amdABC,ddr512).";
               
                             
       	static public void main(String args[]) {
		GrafikusFelulet g = new GrafikusFelulet();
                g.setVisible(true);
                /*String r = run(program0,"szamitogep(P,Mem,A,H,B,Mo,suseLinux)");
                System.out.println(r);
                for (int i=0;i<7;i++) {
                    System.out.print(processResult(r,"szamitogep",1,i+1));
                    System.out.print("\t");
                }*/
	}

       
	/* A Prolog-Interpreter magja es a mi programunk 
           kozti kapcsolatot teremti meg. */
	protected static String run(String prog, String query) {
                Term t; Engine eng;
                String result="";
                try {
                        t = new Term(new ParseString(query,null));
			try {
			    eng = new Engine(t, ParseString.consult(prog, new Hashtable(),null));
			    String result0=eng.run(true); 
                            result=result0;
                            while( result0.indexOf("Yes") == 0 ) {
                                   result0=eng.more(true);
                                   result+="\n"+result0;
                            }
                	} catch (Exception f) { 
				System.out.println("Can't parse program!");
			}
                } catch (Exception f) {
                        System.out.println("Can't parse query!\n");
                        t = null; // dummy
                }
                return result;
	}

        protected static String processResult(String r0, String predicate, int answer, int arg) {
                int pos;
                predicate=predicate+"(";
                for (int i=1;i<=answer;i++)
                    {
                         pos = r0.indexOf(predicate);
                         r0=r0.substring(pos+predicate.length());
                    }
                for (int i=1;i<arg;i++)
                    {
                         pos = r0.indexOf(",");
                         r0=r0.substring(pos+1);
                    }
                int pos1 = r0.indexOf(",");
                int pos2 = r0.indexOf(")");
                if (pos1==-1) { pos = pos2; }
                else if (pos2==-1) { pos = pos1; }
                else pos=Math.min(pos1,pos2);
                return r0.substring(0,pos);
        }
        protected static int answerAmount(String r0, String predicate) {
                int i=0;
                int pos;
                predicate=predicate+"(";
                while ( (pos = r0.indexOf(predicate)) != -1) {
                         i++;
                         r0=r0.substring(pos+predicate.length());
                }
                return i;
        }

}
