import java.util.Hashtable;
import javax.swing.*;

/* Ez a pelda azt hivatott bemutatni, hogyan lehet Prolog-kodot 
   beagyazni Java-programba. 
   
   Az elso peldan bemutatott programhoz illesztunk Java-ban keszitett
   grafikus feluletet. */

class GrafikusFelulet extends JFrame implements java.awt.event.ActionListener {
   private String[] valaszthatok = {"igen","nem","nem tudjuk"};
   private JComboBox[] vizsgalatieredmenyek, tanacseredmenyek;
   private String[] vizsgalatok = {"Lazas","Kohog","Tulsulyos","No","Ultrahang Baba",
     "Nagyhasu","Fogafaj","Dohanyos","Szuvasfogu","Inygyulladt"};
   private String[] tanacsok = { "Megfazott", "Terhes", "Fogyokura", "Fogtomes szuks.", 
     "Gyul. csokk. szuks.", "Cigi eltiltas"};
   private JTextField kicsoda; 
   private JButton lekerdez;
   private JTextArea valasz;
   private boolean[] b;
   public GrafikusFelulet() {
     super();
     setBounds(0,0,500,300);
     setTitle("Tanacsado program DEMO");
     setDefaultCloseOperation(DISPOSE_ON_CLOSE);
     java.awt.Container felulet = getContentPane();
     felulet.setLayout(null);

     JLabel l1 = new JLabel("Vizsgalatok eredmenyei ");
     l1.setBounds(10,20,250,20);
     felulet.add(l1);
     
     vizsgalatieredmenyek = new JComboBox[vizsgalatok.length];
     b=new boolean[vizsgalatok.length];
     for (int i=0;i<vizsgalatok.length;i++) { 
       JLabel l2 = new JLabel(vizsgalatok[i]);
       l2.setBounds(10,40+i*20,100,18);
       felulet.add(l2);
       vizsgalatieredmenyek[i]=new JComboBox(valaszthatok);
       vizsgalatieredmenyek[i].setBounds(150,40+i*20,100,18);
       felulet.add(vizsgalatieredmenyek[i]);
     }     
 
     JLabel l3 = new JLabel("Tanacsok ");
     l3.setBounds(270,20,250,20);
     felulet.add(l3);
     
     tanacseredmenyek = new JComboBox[tanacsok.length];
     for (int i=0;i<tanacsok.length;i++) { 
       JLabel l4 = new JLabel(tanacsok[i]);
       l4.setBounds(270,40+i*20,100,18);
       felulet.add(l4);
       tanacseredmenyek[i]=new JComboBox(valaszthatok);
       tanacseredmenyek[i].setBounds(380,40+i*20,100,18);
       felulet.add(tanacseredmenyek[i]);
     }     

     lekerdez=new JButton("Adj tanacsot!");
     lekerdez.setBounds(270,220,150,20);
     felulet.add(lekerdez);
     lekerdez.addActionListener(this);
   } 
  public void actionPerformed(java.awt.event.ActionEvent e) {
     String allapot =  ""; /* ezek a klozok a konkret allapothoz tartoznak */
     
     if (vizsgalatieredmenyek[0].getSelectedIndex()==0) {  allapot+="lazas(beteg). "; }
     if (vizsgalatieredmenyek[1].getSelectedIndex()==0) {  allapot+="kohog(beteg). "; }
     if (vizsgalatieredmenyek[2].getSelectedIndex()==0) {  allapot+="tulsulyos(beteg). ";}
     if (vizsgalatieredmenyek[3].getSelectedIndex()==0) {  allapot+="no(beteg). ";}
     if (vizsgalatieredmenyek[4].getSelectedIndex()==0) {  allapot+="ultrahangbabalatszik(beteg). ";}
     if (vizsgalatieredmenyek[5].getSelectedIndex()==0) {  allapot+="nagyhasu(beteg). ";}
     if (vizsgalatieredmenyek[6].getSelectedIndex()==0) {  allapot+="fogafaj(beteg). ";}
     if (vizsgalatieredmenyek[7].getSelectedIndex()==0) {  allapot+="dohanyos(beteg). ";}
     if (vizsgalatieredmenyek[8].getSelectedIndex()==0) {  allapot+="szuvasfogu(beteg). ";}
     if (vizsgalatieredmenyek[9].getSelectedIndex()==0) {  allapot+="inygyulladt(beteg). ";}
     
     if (vizsgalatieredmenyek[0].getSelectedIndex()==1) {  allapot+="lazas(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[1].getSelectedIndex()==1) {  allapot+="kohog(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[2].getSelectedIndex()==1) {  allapot+="tulsulyos(beteg) :- fail.";}
     if (vizsgalatieredmenyek[3].getSelectedIndex()==1) {  allapot+="no(beteg) :- fail.";}
     if (vizsgalatieredmenyek[4].getSelectedIndex()==1) {  allapot+="ultrahangbabalatszik(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[5].getSelectedIndex()==1) {  allapot+="nagyhasu(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[6].getSelectedIndex()==1) {  allapot+="fogafaj(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[7].getSelectedIndex()==1) {  allapot+="dohanyos(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[8].getSelectedIndex()==1) {  allapot+="szuvasfogu(beteg) :- fail. ";}
     if (vizsgalatieredmenyek[9].getSelectedIndex()==1) {  allapot+="inygyulladt(beteg) :- fail. ";}
    
     /* A WProlog hibat jelez - tehat nem ad se "Yes" se "No" eredmenyt -, ha olyan klozt 
        hivunk, mely egy nem letezo predikatumra hivatkozik: ezt hasznaljuk ki. 
        Kezdetben "nem tudjuk"-ra allitjuk a valaszmezoket, es amelyekhez tartozo Prolog
        hivasok Yes vagy No eredmenyt adnak, azokat allitjuk be ennek megfeleloen 
    
        Ez a megoldas nem tokeletes: ha egy predikatum egyik tagja hianyzik, akkor
        elofordulhat, hogy a masikbol is meg lehet allapitani a kimenetet
        (pl. ha ES-kapcsolat egyik tagja "FALSE", akkor barmi lehet a masik.) 
     */

     for (int i=0;i<tanacseredmenyek.length;i++) {
       tanacseredmenyek[i].setSelectedIndex(2);
       String eredm="";
       if (i==0) eredm=(Pelda4.run(Pelda4.program0+allapot,"megfazott(beteg)"));
       if (i==1) eredm=(Pelda4.run(Pelda4.program0+allapot,"terhes(beteg)"));
       if (i==2) eredm=(Pelda4.run(Pelda4.program0+allapot,"fogyokuraszukseges(beteg)"));
       if (i==3) eredm=(Pelda4.run(Pelda4.program0+allapot,"fogtomesszukseges(beteg)"));
       if (i==4) eredm=(Pelda4.run(Pelda4.program0+allapot,"gyulcsokszukseges(beteg)"));
       if (i==5) eredm=(Pelda4.run(Pelda4.program0+allapot,"cigarettaeltiltas(beteg)"));
       if (eredm.startsWith("Yes")) { tanacseredmenyek[i].setSelectedIndex(0); } 
       if (eredm.startsWith("No")) { tanacseredmenyek[i].setSelectedIndex(1); } 
     }
  
    
   }        
}

public class Pelda4 {
        
        /* Jelen esetben programunk ket reszbol all: elso egy logikai szabalyhalmaz,
           mely a "tanacsado-rendszer" alapjat kepezi, masodik resz pedig egy-egy
           beteg allapotat leiro elemi predikatumok sokasaga, melyet a felhasznalotol kapott
           valaszok alapjan toltunk csak ki kesobb.*/
        protected static String program0=
                        "megfazott(X) :- lazas(X),kohog(X). "+
                        "terhes(X) :- no(X),nagyhasu(X),ultrahangbabalatszik(X). "+
                        "fogyokuraszukseges(X) :- nagyhasu(X), tulsulyos(X). "+
                        "fogtomesszukseges(X) :- fogafaj(X), szuvasfogu(X)."+
                        "gyulcsokszukseges(X) :- fogafaj(X), inygyulladt(X)."+
                        "cigarettaeltiltas(X) :- dohanyos(X), terhes(X). "+
                        "cigarettaeltiltas(X) :- dohanyos(X), kohog(X), not(megfazott(X))."; 
               
                             
       	static public void main(String args[]) {
		GrafikusFelulet g = new GrafikusFelulet();
                g.setVisible(true);
	}

        /* A Prolog-Interpreter magja es a mi programunk 
           kozti kapcsolatot teremti meg.
           A jelenlegi valtozatban csak az elso megoldasra vagyunk kivancsiak: 
           arra, hogy egy-egy kezelesre/betegsegre igen-t vagy nem-et mond-e
         */
	protected static String run(String prog, String query) {
                Term t; Engine eng;
                String result="";
                try {
                        t = new Term(new ParseString(query,null));
			try {
			    eng = new Engine(t, ParseString.consult(prog, new Hashtable(),null));
			    result=eng.run(true); 
                	} catch (Exception f) { 
				System.out.println("Can't parse program!");
			}
                } catch (Exception f) {
                        System.out.println("Can't parse query!\n");
                        t = null; // dummy
                }
                return result;
	}
}
