import java.util.Hashtable;
import javax.swing.*;

/* Ez a pelda azt hivatott bemutatni, hogyan lehet Prolog-kodot 
   beagyazni Java-programba. 
   
   Az elso peldan bemutatott programhoz illesztunk Java-ban keszitett
   grafikus feluletet. */

class GrafikusFelulet extends JFrame implements java.awt.event.ActionListener {
   private String[] valaszthatok = {"apja?","anyja?","szulei?","testverei?",
           "hazastarsa?","nagybacsiai?","nagynenjei?"};
   private JComboBox valaszto;
   private JTextField kicsoda; 
   private JButton lekerdez;
   private JTextArea valasz;
   public GrafikusFelulet() {
     super();
     setBounds(0,0,500,300);
     setTitle("Rokonsag");
     setDefaultCloseOperation(DISPOSE_ON_CLOSE);
     java.awt.Container felulet = getContentPane();
     felulet.setLayout(null);

     JLabel l1 = new JLabel("Ki(k)");
     l1.setBounds(10,20,30,20);
     felulet.add(l1);

     kicsoda = new JTextField();
     kicsoda.setBounds(45,20,95,20);
     felulet.add(kicsoda);

     valaszto=new JComboBox(valaszthatok);
     valaszto.setBounds(150,20,100,20);
     felulet.add(valaszto);     

     lekerdez=new JButton("Valaszolj!");
     lekerdez.setBounds(260,20,100,20);
     felulet.add(lekerdez);
     lekerdez.addActionListener(this);

     valasz = new JTextArea();
     JScrollPane gorgetomezo = new JScrollPane(valasz); 
     gorgetomezo.setBounds(10,50,470,220);
     felulet.add(gorgetomezo);
   } 
  public void actionPerformed(java.awt.event.ActionEvent e) {
     String eredmeny="";
     if (valaszto.getSelectedIndex()==0) { 
        eredmeny=Pelda2.run(Pelda2.program, "apja("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==1) { 
        eredmeny=Pelda2.run(Pelda2.program, "anyja("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==2) { 
        eredmeny=Pelda2.run(Pelda2.program, "szuloje("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==3) { 
        eredmeny=Pelda2.run(Pelda2.program, "testverek("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==4) { 
        eredmeny=Pelda2.run(Pelda2.program, "hazasok("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==5) { 
        eredmeny=Pelda2.run(Pelda2.program, "nagybacsi("+kicsoda.getText()+",X)." ); 
     }
     if (valaszto.getSelectedIndex()==6) { 
        eredmeny=Pelda2.run(Pelda2.program, "nagyneni("+kicsoda.getText()+",X)." ); 
     }
     valasz.append(eredmeny+"\n\n");
   }        
}

public class Pelda2 {
        
        /* apja...(kinek,kicsoda*/
        protected static String program="no(anna). no(kati). no(mariann)."+
                "ffi(tamas). ffi(gabor). ffi(laszlo). ffi(daniel)."+ 
                "apja(anna,gabor)."+
                "apja(kati,gabor)."+
                "apja(mariann,laszlo)."+
                "apja(tamas,laszlo)."+
                "apja(daniel,laszlo)."+
                "hazasok(gabor,mariann)."+
                "anyja(X,Y) :- apja(X,Z),hazasok(Z,Y)."+ 
                   /* feltetlezzuk, hogy mindenki legfeljebb egyszer hazasodik es csak
                      hazassagban szuletnek gyerekek */ 
                "testverek(X,Y) :- apja(X,Z), apja(Y,Z), not(eq(X,Y))."+
                "szuloje(X,Y) :- apja(X,Y)."+
                "szuloje(X,Y) :- anyja(X,Y)."+
                "nagyneni(X,Y) :- no(Y), szuloje(X,Z), testverek(Z,Y)."+
                "nagybacsi(X,Y) :- ffi(Y), szuloje(X,Z), testverek(Z,Y)."; 
        
       	static public void main(String args[]) {
		GrafikusFelulet g = new GrafikusFelulet();
                g.setVisible(true);
	}

        /* A Prolog-Interpreter magja es a mi programunk 
           kozti kapcsolatot teremti meg. */
	protected static String run(String prog, String query) {
                Term t; Engine eng;
                String result="";
                try {
                        t = new Term(new ParseString(query,null));
			try {
			    eng = new Engine(t, ParseString.consult(prog, new Hashtable(),null));
			    String result0=eng.run(true); 
                            result=result0;
                            while( result0.indexOf("Yes") == 0 ) {
                                   result0=eng.more(true);
                                   result+="\n"+result0;
                            }
                	} catch (Exception f) { 
				System.out.println("Can't parse program!");
			}
                } catch (Exception f) {
                        System.out.println("Can't parse query!\n");
                        t = null; // dummy
                }
                return result;
	}
}
