import java.util.Hashtable;

/* Ez a pelda azt hivatott bemutatni, hogyan lehet Prolog-kodot 
   beagyazni Java-programba. 
   Ez az elso pelda meg nem rendelkezik grafikus felulettel */

public class Pelda1 {
        
        /* apja...(kinek,kicsoda*/
        private static String program="no(anna). no(kati). no(mariann)."+
                "ffi(tamas). ffi(gabor). ffi(laszlo). ffi(daniel)."+ 
                "apja(anna,gabor)."+
                "apja(kati,gabor)."+
                "apja(mariann,laszlo)."+
                "apja(tamas,laszlo)."+
                "apja(daniel,laszlo)."+
                "hazasok(gabor,mariann)."+
                "anyja(X,Y) :- apja(X,Z),hazasok(Z,Y)."+ 
                   /* feltetlezzuk, hogy mindenki legfeljebb egyszer hazasodik es csak
                      hazassagban szuletnek gyerekek */ 
                "testverek(X,Y) :- apja(X,Z), apja(Y,Z), not(eq(X,Y))."+
                "szuloje(X,Y) :- apja(X,Y)."+
                "szuloje(X,Y) :- anyja(X,Y)."+
                "nagyneni(X,Y) :- no(Y), szuloje(X,Z), testverek(Z,Y)."+
                "nagybacsi(X,Y) :- ffi(Y), szuloje(X,Z), testverek(Z,Y)."; 
                       

	static public void main(String args[]) {
		System.out.println("Anna nagybacsiai:");
                System.out.println(run(program,"nagybacsi(anna,X)"));
		
                System.out.println("Anna testverei:");                
                System.out.println(run(program,"testverek(anna,X)"));               
                
		System.out.println("Anna nagyneniei:");
                System.out.println(run(program,"nagyneni(anna,X)"));

	}

        /* A Prolog-Interpreter magja es a mi programunk 
           kozti kapcsolatot teremti meg. */
	static private String run(String prog, String query) {
                Term t; Engine eng;
                String result="";
                try {
                        t = new Term(new ParseString(query,null));
			try {
			    eng = new Engine(t, ParseString.consult(prog, new Hashtable(),null));
			    String result0=eng.run(true); 
                            result=result0;
                            while( result0.indexOf("Yes") == 0 ) {
                                   result0=eng.more(true);
                                   result+="\n"+result0;
                            }
                	} catch (Exception f) { 
				System.out.println("Can't parse program!");
			}
                } catch (Exception f) {
                        System.out.println("Can't parse query!\n");
                        t = null; // dummy
                }
                return result;
	}
}
