includes ioboard;

module HPLButtonsM {
	//provides interface SimpleIO;
//	provides interface StdControl;
	provides interface Button[uint8_t num];
//	uses interface Timer[uint8_t num];
	uses interface Timer as Timer1;
	uses interface Timer as Timer2;
	uses interface Timer as Timer3;
}

implementation {
/*
	async command result_t SimpleIO.writeByte(uint8_t data) {
		return FAIL;
	}

	async command uint8_t SimpleIO.readByte() {
		register uint8_t res;
		res =  !TOSH_READ_BUTTON_1_PIN();
		res |= !TOSH_READ_BUTTON_2_PIN()<<1;
		res |= !TOSH_READ_BUTTON_3_PIN()<<2;
		return res;
	}
*/
	uint8_t prevstate = 0;
/*
	command result_t StdControl.init() {
		return SUCCESS;
	}
	command result_t StdControl.start() {
		return SUCCESS;
	}

	command result_t StdControl.stop() {
		return SUCCESS;
	}
	*/
	async command bool Button.isPressed[uint8_t num]() {
		switch (num) {
			case 1:		
				return !TOSH_READ_BUTTON_1_PIN();
				break;
			case 2:		
				return !TOSH_READ_BUTTON_2_PIN();
				break;
			case 3:		
				return !TOSH_READ_BUTTON_3_PIN();
				break;
			default:		
				return FALSE;
		}
		return FALSE;
	}
	
	command void Button.setPolling[uint8_t num](uint16_t period) {
		switch (num) {
			case 1:
				if (period==0)
					call Timer1.stop();
				else
					call Timer1.start(TIMER_REPEAT, period);
				break;
			case 2:
				if (period==0)
					call Timer2.stop();
				else
					call Timer2.start(TIMER_REPEAT, period);
				break;
			case 3:
				if (period==0)
					call Timer3.stop();
				else
					call Timer3.start(TIMER_REPEAT, period);
				break;
		}
		
	}
	
	default event void Button.pressed[uint8_t num](){
	}
	default event void Button.released[uint8_t num](){
	}
	
	event result_t Timer1.fired() {
		bool current = call Button.isPressed[1]();
		bool last = prevstate & 1;
		if (current != last)
			if (current) {
				signal Button.pressed[1]();
				prevstate |= 1;
			} else {
				signal Button.released[1]();
				prevstate &= ~1;
			}
		return SUCCESS;
	}

	event result_t Timer2.fired() {
		bool current = call Button.isPressed[2]();
		bool last = !!(prevstate & 2);
		if (current != last)
			if (current) {
				signal Button.pressed[2]();
				prevstate |= 2;
			} else {
				signal Button.released[2]();
				prevstate &= ~2;
			}
		return SUCCESS;
	}

	event result_t Timer3.fired() {
		bool current = call Button.isPressed[3]();
		bool last = !!(prevstate & 4);
		if (current != last)
			if (current) {
				signal Button.pressed[3]();
				prevstate |= 4;
			} else {
				signal Button.released[3]();
				prevstate &= ~4;
			}
		return SUCCESS;
	}
}
