includes ioboard;

module Leds4C {
	
	provides interface Leds4;
	provides interface IntOutput;
}


implementation {
	uint8_t ledsOn;
	async command result_t Leds4.init() {
		atomic {
			ledsOn = 0;
			//dbg(DBG_BOOT, "LEDS: initialized.\n");
			TOSH_MAKE_LED_1_OUTPUT();
			TOSH_MAKE_LED_2_OUTPUT();
			TOSH_MAKE_LED_3_OUTPUT();
			TOSH_MAKE_LED_4_OUTPUT();
			TOSH_CLR_LED_1_PIN();
			TOSH_CLR_LED_2_PIN();
			TOSH_CLR_LED_3_PIN();
			TOSH_CLR_LED_4_PIN();
		}
		return SUCCESS;
	}
	
	async command result_t Leds4.led1On() {
		atomic {
			TOSH_SET_LED_1_PIN();
			ledsOn |= 1;
		}
		return SUCCESS;
	}

	async command result_t Leds4.led1Off() {
		atomic {
			TOSH_CLR_LED_1_PIN();
			ledsOn &= ~1;
		}
		return SUCCESS;
	}


	async command result_t Leds4.led1Toggle() {
		atomic {
			ledsOn^=1;
			if (ledsOn & 1)
				TOSH_SET_LED_1_PIN();
			else
				TOSH_CLR_LED_1_PIN();
		}
		return SUCCESS;
	}

	async command result_t Leds4.led2On() {
		atomic {
			TOSH_SET_LED_2_PIN();
			ledsOn |= 2;
		}
		return SUCCESS;
	}

	async command result_t Leds4.led2Off() {
		atomic {
			TOSH_CLR_LED_2_PIN();
			ledsOn &= ~2;
		}
		return SUCCESS;
	}


	async command result_t Leds4.led2Toggle() {
		atomic {
			ledsOn^=2;
			if (ledsOn & 2)
				TOSH_SET_LED_2_PIN();
			else
				TOSH_CLR_LED_2_PIN();
		}
		return SUCCESS;
	}

	async command result_t Leds4.led3On() {
		atomic {
			TOSH_SET_LED_3_PIN();
			ledsOn |= 4;
		}
		return SUCCESS;
	}

	async command result_t Leds4.led3Off() {
		atomic {
			TOSH_CLR_LED_3_PIN();
			ledsOn &= ~4;
		}
		return SUCCESS;
	}


	async command result_t Leds4.led3Toggle() {
		atomic {
			ledsOn^=4;
			if (ledsOn & 4)
				TOSH_SET_LED_3_PIN();
			else
				TOSH_CLR_LED_3_PIN();
		}
		return SUCCESS;
	}

	async command result_t Leds4.led4On() {
		atomic {
			TOSH_SET_LED_4_PIN();
			ledsOn |= 8;
		}
		return SUCCESS;
	}

	async command result_t Leds4.led4Off() {
		atomic {
			TOSH_CLR_LED_4_PIN();
			ledsOn &= ~8;
		}
		return SUCCESS;
	}


	async command result_t Leds4.led4Toggle() {
		atomic {
			ledsOn^=8;
			if (ledsOn & 8)
				TOSH_SET_LED_4_PIN();
			else
				TOSH_CLR_LED_4_PIN();
		}
		return SUCCESS;
	}

	async command result_t Leds4.ledOn(uint8_t ledNum) {
		if (ledNum<1||ledNum>4)
			return FAIL;
		atomic {
			switch(ledNum) {
				case 1:
					TOSH_SET_LED_1_PIN();
					break;
				case 2:
					TOSH_SET_LED_2_PIN();
					break;
				case 3:
					TOSH_SET_LED_3_PIN();
					break;
				case 4:
					TOSH_SET_LED_4_PIN();
					break;
			}
			ledsOn |= 1<<(ledNum-1);
		}
		return SUCCESS;
	}

	async command result_t Leds4.ledOff(uint8_t ledNum) {
		if (ledNum<1||ledNum>4)
			return FAIL;
		atomic {
			switch(ledNum) {
				case 1:
					TOSH_CLR_LED_1_PIN();
					break;
				case 2:
					TOSH_CLR_LED_2_PIN();
					break;
				case 3:
					TOSH_CLR_LED_3_PIN();
					break;
				case 4:
					TOSH_CLR_LED_4_PIN();
					break;
			}
			ledsOn &= ~(1<<(ledNum-1));
		}
		return SUCCESS;
	}


	async command result_t Leds4.ledToggle(uint8_t ledNum) {
		if (ledNum<1||ledNum>4)
			return FAIL;
		atomic {
			uint8_t mask = 1<<(ledNum-1);
			ledsOn ^= mask;
			if (ledsOn & mask)
				switch(ledNum) {
					case 1:
						TOSH_SET_LED_1_PIN();
						break;
					case 2:
						TOSH_SET_LED_2_PIN();
						break;
					case 3:
						TOSH_SET_LED_3_PIN();
						break;
					case 4:
						TOSH_SET_LED_4_PIN();
						break;
				}
			else
				switch(ledNum) {
					case 1:
						TOSH_CLR_LED_1_PIN();
						break;
					case 2:
						TOSH_CLR_LED_2_PIN();
						break;
					case 3:
						TOSH_CLR_LED_3_PIN();
						break;
					case 4:
						TOSH_CLR_LED_4_PIN();
						break;
				}
		}
		return SUCCESS;
	}
	
 
	async command uint8_t Leds4.get(){
		uint8_t rval;
		atomic {
			rval = ledsOn;
		}
		return rval; 
	}

    async command result_t Leds4.set(uint8_t ledsState){
		atomic {
			ledsOn = (ledsState & 0xF);
			if (ledsOn & 1) 
				TOSH_SET_LED_1_PIN();
			else
				TOSH_CLR_LED_1_PIN();
			if (ledsOn & 2) 
				TOSH_SET_LED_2_PIN();
			else
				TOSH_CLR_LED_2_PIN();
			if (ledsOn & 4) 
				TOSH_SET_LED_3_PIN();
			else
				TOSH_CLR_LED_3_PIN();
			if (ledsOn & 8) 
				TOSH_SET_LED_4_PIN();
			else
				TOSH_CLR_LED_4_PIN();
		}
		return SUCCESS; 	
	}

// IntOutput

  task void outputDone()
  {
    signal IntOutput.outputComplete(1);
  }

  command result_t IntOutput.output(uint16_t value)
  {
	call Leds4.set((int8_t)value);
    post outputDone();
    return SUCCESS;
  } 
}
