/*
 * Author:		Laszlo Siroki
 *
 * Interface for IA4420 specific controls and signals
 */

/**
 * IA4420 Radio Control interface.
 */
interface IA4420Control
{
	/** 
	* @param freq 
	* frequency = 430 + freq * 0.0025  MHz
	*/
	command result_t SetFrequency(uint16_t freq);

	/**
	* 
	*/
	command result_t SetDataRate(uint8_t rate);

	/**
	* @param power TX power = max - 3*power dB.  0 = max ... 7 = -21 dB (min)
	*/
	command result_t SetTXPower(uint8_t power);	

/*
	command result_t SetBandwidth();

	command result_t SetDeviation();
*/

/*
	command result_t enableTransmitter();

	command result_t disableTransmitter();

	command result_t enableReceiver();

	command result_t disableReceiver();
*/
//	command result_t setRxTxMode(bool rxenabled, bool txenabled);

	command result_t poweroff();
/*
	async command result_t IdleMode();
*/

//	command result_t SetRXSensitivity();	

/*
	command result_t SetWakeupTimer();

	command result_t SetLowBattery();

	command result_t SetClockDivider();
*/

}
