module HPLIA4420M {
	provides{
		interface IA4420Interrupt;
		interface HPLIA4420Command;
	}
	uses {
		interface IA4420Spi;
		interface BusArbitration;
		interface FastSPI;
//		interface IntOutput as Debug;
#ifdef RADIO_DEBUG
		interface DiagMsg;
#endif
	}
}

implementation {
	enum {
		IDLE = 0,
		COMMAND_PENDING = 1,
		COMMAND_CSC,
		COMMAND_PMC,
		COMMAND_FSC,
		COMMAND_DRC,
		COMMAND_RCC,
		COMMAND_DFC,
		COMMAND_FRMC,
		COMMAND_RFRC,
		COMMAND_AFCC,
		COMMAND_TXCCC,
		COMMAND_TRWC,
		COMMAND_WUTC,
		COMMAND_LDCC,
		COMMAND_LBDMCDC,
		COMMAND_SRC
	};
	uint8_t state = IDLE;
	
	enum {
		NO_IT = 0,
		IT_WAITING_FOR_BUS,
		IT_GETTING_STATUS
	};
	uint8_t intstate = NO_IT;
	
	uint16_t response = 0;
	
	uint8_t powerreg = 0x08;
	uint8_t txcontrolreg = 0x00;

/*
	default event result_t IA4420Interrupt.FFIT() {
		return SUCCESS;
	}
	
	default event void IA4420Interrupt.RGIT() {return;}
	default event void IA4420Interrupt.POR() {return;}
	default event void IA4420Interrupt.RGUR() {return;}
	default event void IA4420Interrupt.FFOV() {return;}
	default event void IA4420Interrupt.WKUP() {return;}
	default event void IA4420Interrupt.EXT() {return;}
	default event void IA4420Interrupt.LBD() {return;}
*/


	void debug(char *str, uint16_t num) {
#ifdef RADIO_DEBUG
		if (call DiagMsg.record()) {
			call DiagMsg.str(str); 
			call DiagMsg.uint16(num); 
			call DiagMsg.send();
		}
#endif
	}


//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////


	static void doGetStatus();
	
	TOSH_SIGNAL(SIG_RADIO_INT) {

		cbi(EIMSK, EXT_INT0_BIT);

		cbi(EICRB, EXT_INT0_SC0);
		sbi(EICRB, EXT_INT0_SC1);

		sbi(EIMSK, EXT_INT0_BIT);

//		handleInterrupt();		
		if (intstate == NO_IT) {
			intstate = IT_WAITING_FOR_BUS;
			if (call BusArbitration.getBus() == SUCCESS)
				doGetStatus();
			
		}

	}

	async command void IA4420Interrupt.checkInterrupt() {
		// Setting up interrupt on low _level_
		debug("chkINT", 0);
		cbi(EIMSK, EXT_INT0_BIT);
		cbi(EICRB, EXT_INT0_SC0);
		cbi(EICRB, EXT_INT0_SC1);
		sbi(EIMSK, EXT_INT0_BIT);

	}

/*
	// IA4420Spi.sendCommand()
	void handleInterrupt() {
		uint8_t ls;
		atomic {
			ls=intstate;
			if (ls==NO_IT)
				intstate = IT_WAITING_FOR_BUS;
		}
		if (ls != NO_IT)
			return; //TODO: rkezhet jabb IT, amg egyet feldolgozok?
		
		if (call BusArbitration.getBus() == SUCCESS) {
			post doGetStatus();
		}
	}
	*/
	void evaluateStatus(uint8_t byte, uint8_t preg);
	
	static void doGetStatus(){
		uint8_t byte, preg;
		atomic {
			intstate = IT_GETTING_STATUS;
			preg = powerreg;
			debug_b |= 32;
		}
		TOSH_CLR_IA4420_NSEL_PIN();
		byte = call FastSPI.txByte(0);
		TOSH_SET_IA4420_NSEL_PIN();

		debug("INT", byte);

		//??
//		call BusArbitration.releaseBus();
		//atomic 

//		response = ((uint16_t)byte)<<8;

//		if ( (byte&0xFC) != 0x80)

//			call Debug.output(byte>>5);


/*
		atomic {
			ls=intstate;
			if (ls == IT_GETTING_STATUS) {
				IA4420Status = response;
				intstate = NO_IT;
			}
		}

		if (ls!=IT_GETTING_STATUS)
			return;
*/ 
		evaluateStatus(byte, preg);


		atomic intstate = NO_IT;

		call BusArbitration.releaseBus();
		
	}

	void evaluateStatus(uint8_t byte, uint8_t preg) {
		if (byte & (1<<(RGUR-8))) // RGUR==FFOV
		{
			if (preg & 0x80) // er bit is set
				signal IA4420Interrupt.FFOV();
			else
				signal IA4420Interrupt.RGUR();
		}		


		if ((byte & (1<<(FFIT-8)))) // FFIT==RGIT
		{
			if (preg & 0x80) // er bit is set
				signal IA4420Interrupt.FFIT();
			else
				signal IA4420Interrupt.RGIT();
		}	

		if (byte & (1<<(POR-8)))
		{
			signal IA4420Interrupt.POR();
		}



		if (byte & (1<<(WKUP-8)))
		{
//			call Debug.output(7);
			signal IA4420Interrupt.WKUP();
		}

		if (byte & (1<<(EXT-8)))
		{
//			call Debug.output(7);
			signal IA4420Interrupt.EXT();
		}

		if (byte & (1<<(LBD-8)))
		{
//			call Debug.output(7);
			signal IA4420Interrupt.LBD();
		}

	}
	
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////

	// Configuration Setting Command
	async command result_t HPLIA4420Command.CSC(uint8_t config) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_CSC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("CSC", config);
		if (call IA4420Spi.sendCommand(0x80, config)) // == SUCCESS allways
		{
			return SUCCESS;
		}
		atomic state = IDLE;
		return FAIL;
	}
/*
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				state = COMMAND_PENDING;
		}
		if (ls!=IDLE)
			return FAIL;
		if (call IA4420Spi.sendCommand(0x80, config))
		{
			atomic state = COMMAND_CSC;
			return SUCCESS;
		}
		atomic state = IDLE;
		return FAIL;

*/


	// Power Management Command
	async command result_t HPLIA4420Command.PMC(uint8_t power) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE) {
				lastcommand = state = COMMAND_PMC;
				powerreg = power;
			}
		}
		if (ls!=IDLE)
			return FAIL;
		debug("PMC", power);
		if (call IA4420Spi.sendCommand(0x82, power))
		{
//			powerreg = power;
			return SUCCESS;
		}
		atomic state = IDLE;
		return FAIL;
	}

	// Frequency Setting Command
	async command result_t HPLIA4420Command.FSC(uint16_t freq) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_FSC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("FSC", freq);
		return call IA4420Spi.sendCommand(0xA0 | ((freq>>8)&0x0F), (uint8_t)(freq & 0xFF));
	}

	// Data Rate Command
	async command result_t HPLIA4420Command.DRC(uint8_t rate) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_DRC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("DRC", rate);
		return call IA4420Spi.sendCommand(0xC6, rate);
	}

	// Receiver Control Command
	async command result_t HPLIA4420Command.RCC(uint16_t rxcontrol) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_RCC;
		}
		if (ls!=IDLE)
			return FAIL;
		return call IA4420Spi.sendCommand(0x90 | ((rxcontrol>>8)&0x07), (uint8_t)(rxcontrol & 0xFF));
	}

	// Data Filter Command
	async command result_t HPLIA4420Command.DFC(uint8_t filter) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_DFC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("DFC", filter);
		return call IA4420Spi.sendCommand(0xC2, filter);
	}

	// FIFO and Reset Mode Command
	async command result_t HPLIA4420Command.FRMC(uint8_t mode) {
		uint8_t ls; result_t res;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_FRMC;
		}
		if (ls!=IDLE)
			return FAIL;
		res = call IA4420Spi.sendCommand(0xCA, mode);
		debug("FRMC", mode);
		return res;
	}

	// Receiver FIFO Read Command
	async command result_t HPLIA4420Command.RFRC() {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_RFRC;
		}
		if (ls!=IDLE)
			return FAIL;
//		debug("RFRC",0);
		return call IA4420Spi.sendCommand(0xB0, 0x00);
	}

	// AFC Command
	async command result_t HPLIA4420Command.AFCC(uint8_t afc) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_AFCC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("AFCC", afc);
		return call IA4420Spi.sendCommand(0xC4, afc);
	}

	async command result_t HPLIA4420Command.SetTXPower(uint8_t txpower) {
		uint16_t txc;
		atomic {
			txc = (txcontrolreg & 0xF0)|(txpower & 0x0F);
		}
		return call HPLIA4420Command.TXCCC(txc);
	}
	
	// TX Configuration Control Command
	async command result_t HPLIA4420Command.TXCCC(uint16_t txcontrol) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE) {
				lastcommand = state = COMMAND_TXCCC;
				txcontrolreg = txcontrol;
			}
		}
		if (ls!=IDLE)
			return FAIL;
		debug("TXCCC", txcontrol);

		return call IA4420Spi.sendCommand(0x98 | ((txcontrol>>8)&0x01), (uint8_t)(txcontrol & 0xFF));
	}

	// Transmitter Register Write Command
	async command result_t HPLIA4420Command.TRWC(uint8_t data) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_TRWC;
		}
		if (ls!=IDLE)
			return FAIL;
//		debug("TRWC", data);
		return call IA4420Spi.sendCommand(0xB8, data);
	
	}

	// Wake-Up Timer Command
	async command result_t HPLIA4420Command.WUTC(uint8_t m, uint8_t r) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_WUTC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("WUTC", 0);
		return call IA4420Spi.sendCommand(0xE0 | (r & 0x1F), m);
	}

	// Low Duty-Cycle Command
	async command result_t HPLIA4420Command.LDCC(uint8_t duty) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_LDCC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("LDCC", duty);
		return call IA4420Spi.sendCommand(0xC8, duty);
	}

	// Low Battery Detector and Microcontroller Clock Divider Command
	async command result_t HPLIA4420Command.LBDMCDC(uint8_t setting) {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_LBDMCDC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("LBDMCDC", setting);
		return call IA4420Spi.sendCommand(0xC0, setting);
	}
	
	// Status Read Command
	async command result_t HPLIA4420Command.SRC() {
		uint8_t ls;
		atomic {
			ls = state;
			if (ls==IDLE)
				lastcommand = state = COMMAND_SRC;
		}
		if (ls!=IDLE)
			return FAIL;
		debug("SRC",0);
		return call IA4420Spi.sendCommand(0, 0);
	}


//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////


	async event result_t IA4420Spi.receivedResponse(uint8_t byte1, uint8_t byte2) {
		// TODO: ha parancs folyamatban:
		uint8_t ls;
		atomic ls = state;
		switch (ls) {
			case COMMAND_RFRC:
				state = IDLE;
				signal HPLIA4420Command.RFRCDone(byte2);
				call IA4420Interrupt.checkInterrupt();
				break;

			case COMMAND_SRC:
				state = IDLE;
//				if (byte1&0xFC) {
//					atomic evaluateStatus(byte1, powerreg);
//				}
				signal HPLIA4420Command.SRCDone((((uint16_t)byte1)<<8)+byte2);
				break;

			case COMMAND_TRWC:
				state = IDLE;
				call IA4420Interrupt.checkInterrupt();
				signal HPLIA4420Command.TRWCDone();
				break;

			case COMMAND_FRMC: //?
				state = IDLE;
				call IA4420Interrupt.checkInterrupt();
				signal HPLIA4420Command.commandDone();
				break;

			case COMMAND_PMC:
//				debug_b |=16;
			case COMMAND_CSC:
			case COMMAND_FSC:
			case COMMAND_DRC:
			case COMMAND_RCC:
			case COMMAND_DFC:
			case COMMAND_AFCC:
			case COMMAND_TXCCC:
			case COMMAND_WUTC:
			case COMMAND_LDCC:
			case COMMAND_LBDMCDC:
				state = IDLE;
				signal HPLIA4420Command.commandDone();
				break;
				
		}
		return SUCCESS;
	}
	
/*	
	event result_t Debug.outputComplete(result_t success) {
		return SUCCESS;
	}
*/

//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////


	async event result_t BusArbitration.busFree() {
		int8_t lstate;
		atomic lstate = intstate;
		if ((lstate==IT_WAITING_FOR_BUS) && (call BusArbitration.getBus() == SUCCESS))
			doGetStatus();
		return SUCCESS;
	}
 
}
