module LedsM {
	provides interface Leds;
	uses interface Leds4;
}

implementation {
	async command result_t Leds.init() {
		return call Leds4.init();
	}
	
	async command result_t Leds.redOn() {
		return call Leds4.led1On();
	}
	
	async command result_t Leds.redOff() {
		return call Leds4.led1Off();
	}
	
	async command result_t Leds.redToggle() {
		return call Leds4.led1Toggle();
	}


	async command result_t Leds.greenOn() {
		return call Leds4.led2On();
	}
	
	async command result_t Leds.greenOff() {
		return call Leds4.led2Off();
	}
	
	async command result_t Leds.greenToggle() {
		return call Leds4.led2Toggle();
	}


	async command result_t Leds.yellowOn() {
		return call Leds4.led3On();
	}
	
	async command result_t Leds.yellowOff() {
		return call Leds4.led3Off();
	}
	
	async command result_t Leds.yellowToggle() {
		return call Leds4.led3Toggle();
	}
	
	async command uint8_t Leds.get() {
		return (call Leds4.get()) & 0x07;
	}
	async command result_t Leds.set(uint8_t value) {
		value &= 0x07;
		value |= (call Leds4.get() & 8); // Keep led4 state.
		return call Leds4.set(value);
	}
}
