module TempMeterM {
	provides {
		interface StdControl;
	}
	uses {
		interface Timer;
		interface IntOutput;
		interface ADC as TempSensor;
	}
}
implementation {

	uint16_t temp;

	command result_t StdControl.init() {
		return SUCCESS;
	}
	
	command result_t StdControl.start() {
		return call Timer.start(TIMER_REPEAT, 1000); 
	}

	command result_t StdControl.stop() {
		 return call Timer.stop(); 
	}
	
	event result_t Timer.fired()
	{
		call TempSensor.getData();
		return SUCCESS;
	}

	task void outputtask() {
		uint16_t x;
		atomic x=temp*5; // x = (temperature in celsius) * 10
		call IntOutput.output(x);		
	}

	async event result_t TempSensor.dataReady(uint16_t data) {
		atomic temp = data;
		post outputtask();
		return SUCCESS;
	}

	event result_t IntOutput.outputComplete(result_t param)
	{
		return SUCCESS;
	}

}
