#ifndef TOSH_IOBOARD_H_dpy_trm_s01
#define TOSH_IOBOARD_H_dpy_trm_s01

// LEDs
TOSH_ALIAS_PIN(LED_1, GPIO_4);
TOSH_ALIAS_PIN(LED_2, GPIO_5);
TOSH_ALIAS_PIN(LED_3, GPIO_6);
TOSH_ALIAS_PIN(LED_4, GPIO_7);

//Pushbuttons
TOSH_ALIAS_PIN(BUTTON_1, GPIO_1);
TOSH_ALIAS_PIN(BUTTON_2, GPIO_2);
TOSH_ALIAS_PIN(BUTTON_3, GPIO_3);

//switches
TOSH_ALIAS_PIN(SWITCH_1, GPIO_8);
TOSH_ALIAS_PIN(SWITCH_2, GPIO_9);
TOSH_ALIAS_PIN(SWITCH_3, GPIO_10);
TOSH_ALIAS_PIN(SWITCH_4, GPIO_11);

// 7-segment digits can be constructed from some of these segments by &-ing them together
enum {
	SEG_A = ~0x01,
	SEG_B = ~0x02,
	SEG_C = ~0x04,
	SEG_D = ~0x80,
	SEG_E = ~0x40,
	SEG_F = ~0x10,
	SEG_G = ~0x20,
	SEG_DP = ~0x08,
};

/* Number Table 0 1 2 3 4 5 6 7 8 9 A b C d E F Space - Dot */
const unsigned char seg_numbers[19]={
	0x28, 0xF9, 0x1C, 0x58, 0xC9,
	0x4A, 0x0A, 0xF8, 0x08, 0x48,
	0x88, 0x0B, 0x2E , 0x19, 0x0E, 0x8E,
	0xFF, 0xDF, 0xF7};

enum {
	CHAR_SPACE	= 16,
	CHAR_MIN	= 17,
	CHAR_DOT	= 18
};

#endif
