
/**
 *
 * @author Laszlo Siroki
 */

configuration IA4420RadioC
{
  provides {
    interface StdControl;
    interface BareSendMsg as Send;
    interface ReceiveMsg as Receive;
    //interface IA4420Control as RadioControl;
  }
}

implementation
{
	components IA4420RadioM, IA4420SpiC, HPLIA4420M, HPLSpiC,
#ifdef RADIO_DEBUG
//	IntToLeds as IntDebug,
	DiagMsgC,
	TimerC,
#endif	
	TimerJiffyAsyncC, RandomLFSR;
	
	
	StdControl = HPLSpiC;

	StdControl = IA4420SpiC;
	
	StdControl = TimerJiffyAsyncC.StdControl;

	StdControl = IA4420RadioM;

	Send = IA4420RadioM;
	Receive = IA4420RadioM;

	HPLIA4420M.IA4420Spi -> IA4420SpiC;
	
	HPLIA4420M.FastSPI -> HPLSpiC; 
	HPLIA4420M.BusArbitration -> HPLSpiC;
	


#ifdef RADIO_DEBUG
	StdControl = TimerC;
	IA4420RadioM.Timer->TimerC.Timer[unique("Timer")];

//	IA4420RadioM.Debug->IntDebug;
//	HPLIA4420M.Debug->IntDebug;
	IA4420RadioM.DiagMsg->DiagMsgC;
	HPLIA4420M.DiagMsg->DiagMsgC;

#endif	

	IA4420RadioM.IA4420Interrupt -> HPLIA4420M;
	IA4420RadioM.HPLIA4420Command -> HPLIA4420M;

	IA4420RadioM.TimerJiffyAsync -> TimerJiffyAsyncC; 
	IA4420RadioM.Random -> RandomLFSR; 
}
