module TempM
{
	provides {
//		interface StdControl;
		interface ADC as TempSensor; 
	}
	uses {
		interface I2C;
		interface BusArbitration as I2CArbitration;
	}
}
implementation 
{
	enum {
		IDLE,
		WAITING_FOR_BUS,
		SEND_START,
		SEND_ADDRESS1,
		SEND_POINTER,
		SEND_RESTART,
		SEND_ADDRESS2,
		RECEIVE_DATA1,
		RECEIVE_DATA2,
		SEND_STOP,
		FINISH,
	};

	uint8_t state = IDLE; 

	uint8_t data1, data2;
		
	
	task void do_next();

/*
	command result_t StdControl.init() {
		state=IDLE;
		return SUCCESS;
	}
	
	command result_t StdControl.start() {
		return SUCCESS;
	}

	command result_t StdControl.stop() {
		 return SUCCESS;
	}
*/

	async command result_t TempSensor.getData() {
		int8_t lstate;
		atomic {
			lstate = state;
			if (state == IDLE)
				state = WAITING_FOR_BUS;
		}
		if (lstate!=IDLE)
			return FAIL;
		

		if (call I2CArbitration.getBus() == SUCCESS) {
			atomic state = SEND_START;
			post do_next();
		}
		return SUCCESS;
		
	}
	
	async command result_t TempSensor.getContinuousData(){
		// Not implemented yet.
		return FAIL;
	}

	task void do_next() {
		int8_t lstate;
		atomic lstate = state;
		switch(lstate) {
			case SEND_START:
				state = SEND_ADDRESS1;
				call I2C.sendStart();
				break;

			case SEND_ADDRESS1:
				state = SEND_POINTER;
				call I2C.write(0x9E);
				break;

			case SEND_POINTER:
				state = SEND_RESTART;
				call I2C.write(0x00);
				break;

			case SEND_RESTART:
				state = SEND_ADDRESS2;
				call I2C.sendStart();
				break;

			case SEND_ADDRESS2:
				state = RECEIVE_DATA1;
				call I2C.write(0x9F);
				break;

			case RECEIVE_DATA1:
				state = RECEIVE_DATA2;
				call I2C.read(TRUE);
				break;

			case RECEIVE_DATA2:
				state = SEND_STOP;
				call I2C.read(FALSE);
				break;

			case SEND_STOP:
				state = FINISH;
				call I2C.sendEnd();
				break;

			case FINISH:
				state = IDLE;
				call I2CArbitration.releaseBus();
				signal TempSensor.dataReady((((uint16_t)data1)<<1) + (data2>>7));
				break;
				
		}
				
	}

	event result_t I2C.sendStartDone()
	{
		post do_next();
		return SUCCESS;
	}

	event result_t I2C.sendEndDone()
	{
		post do_next();
		return SUCCESS;
	}

	event result_t I2C.writeDone(bool success)
	{
		post do_next();
		return SUCCESS;
	}

	event result_t I2C.readDone(char data)
	{
		//Shifting data
		data1 = data2;
		data2 = data;
		post do_next();
		return SUCCESS;
	}

	async event result_t I2CArbitration.busFree() {
		int8_t lstate;
		atomic lstate = state;
		if ((lstate==WAITING_FOR_BUS) && (call I2CArbitration.getBus() == SUCCESS))
			atomic state = SEND_START;
			post do_next();
		return SUCCESS;
	}
	
}
