/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */
/*
 *
 * Authors:		Joe Polastre
 *
 * $Id: BusArbitrationM.nc,v 1.3 2004/07/09 05:43:48 cssharp Exp $
 */

module BusArbitrationM {
	provides {
		interface BusArbitration[uint8_t id];
		interface StdControl;
	}
}
implementation {
	
	uint8_t state[uniqueCount("BusID")];
	uint8_t rbusid;
	enum { BUS_IDLE, BUS_BUSY, BUS_RELEASED /*, BUS_OFF */};
	
	//TODO: valahogy megoldani tbb busz egyidej felszabadtst!
	task void busReleased() {
		uint8_t currentstate;
		uint8_t i;
		for (i = 0; i < uniqueCount("BusID"); i++) {
			atomic { 
				currentstate = state[i]; 
				if (currentstate == BUS_RELEASED)
					state[i] = BUS_IDLE;
			}
			if (currentstate == BUS_RELEASED)
				signal BusArbitration.busFree[i]();
		}
	}

	command result_t StdControl.init() {
		uint8_t i;
		atomic {
			for (i = 0; i < uniqueCount("BusID"); i++)
				state[i] = BUS_IDLE;
		}
		return SUCCESS;
	}
	
	command result_t StdControl.start() {
		return SUCCESS;
	}
	
	command result_t StdControl.stop() {
		return SUCCESS;
	}
	/**
	* Requests the bus. If it returns SUCCESS, the caller has got the bus,
	* if it returns FAIL, the bus is occupied by someone other.
	*/
	async command result_t BusArbitration.getBus[uint8_t busid]() {
		result_t gotbus = FAIL;
		atomic {
			if (state[busid] == BUS_IDLE) {
				state[busid] = BUS_BUSY;
				gotbus = SUCCESS;
			}
		}
		return gotbus;
	}

	/**
	*   Releases the bus. Should be called only if the caller has the bus!
	*/
	async command result_t BusArbitration.releaseBus[uint8_t busid]() {
		bool release = FALSE;
		atomic {
			if (state[busid] == BUS_BUSY) {
				//state[busid] = BUS_RELEASED;
				state[busid] = BUS_IDLE;
				release=TRUE;
			}
		}
		if (release)
			//post busReleased();
			signal BusArbitration.busFree[busid]();
		return SUCCESS;
	}
	
	/**
	*	Signals that the bus is probably free. At least, somebody has just relased it,
	*  but if there are multiple listeners of this event, somebody may have got the
	*  bus since the relase. If a component wants to access the bus, but the first
	*  getBus() failed, this is the place to retry.
	*
	*  This is only a default implementation.
	*/
	default async event result_t BusArbitration.busFree[uint8_t id]() {
		return SUCCESS;
	}

}

