#ifndef TOSH_IA4420_H
#define TOSH_IA4420_H

TOSH_ALIAS_PIN(IA4420_NSEL, GPIO_13);

// TOSH_ALIAS_PIN(IA4420_NIRQ, GPIO_14);

TOSH_ALIAS_PIN(IA4420_NIRQ, INT0);
#define SIG_RADIO_INT SIG_INTERRUPT5

TOSH_ALIAS_PIN(IA4420_SCK, SPI_SCK);
TOSH_ALIAS_PIN(IA4420_SDI, MOSI);
TOSH_ALIAS_PIN(IA4420_SDO, MISO);
enum {
	TOSH_HEADER_LENGTH = offsetof(struct TOS_Msg, data)
};

enum {
	SUB_BAND_433_1_MHz = 0xA4D8,
	SUB_BAND_433_2_MHz = 0xA500,
	SUB_BAND_433_3_MHz = 0xA528,
	SUB_BAND_433_4_MHz = 0xA550,
	SUB_BAND_433_5_MHz = 0xA578,
	SUB_BAND_433_6_MHz = 0xA5A0,
	SUB_BAND_433_7_MHz = 0xA5C8,
	SUB_BAND_433_8_MHz = 0xA5F0,
	SUB_BAND_433_9_MHz = 0xA618,
	SUB_BAND_434_0_MHz = 0xA640,
	SUB_BAND_434_1_MHZ = 0xA668,
	SUB_BAND_434_2_MHz = 0xA690,
	SUB_BAND_434_3_MHz = 0xA6B8,
	SUB_BAND_434_4_MHz = 0xA6E0,
	SUB_BAND_434_5_MHz = 0xA708,
	SUB_BAND_434_6_MHz = 0xA730,
	SUB_BAND_434_7_MHz = 0xA758
};

enum {
	BASEBAND_BW_400_kHz = 0x20,
	BASEBAND_BW_340_kHz = 0x40,
	BASEBAND_BW_270_kHz = 0x60,
	BASEBAND_BW_200_kHz = 0x80,
	BASEBAND_BW_134_kHz = 0xA0,
	BASEBAND_BW_67_kHz  = 0xC0
};

enum {
	FSK_DEVIATION_15_kHz  = 0x00,
	FSK_DEVIATION_30_kHz  = 0x10,
	FSK_DEVIATION_45_kHz  = 0x20,
	FSK_DEVIATION_60_kHz  = 0x30,
	FSK_DEVIATION_75_kHz  = 0x40,
	FSK_DEVIATION_90_kHz  = 0x50,
	FSK_DEVIATION_105_kHz = 0x60,
	FSK_DEVIATION_120_kHz = 0x70,
	FSK_DEVIATION_135_kHz = 0x80,
	FSK_DEVIATION_150_kHz = 0x90,
	FSK_DEVIATION_165_kHz = 0xA0,
	FSK_DEVIATION_180_kHz = 0xB0,
	FSK_DEVIATION_195_kHz = 0xC0,
	FSK_DEVIATION_210_kHz = 0xD0,
	FSK_DEVIATION_225_kHz = 0xE0,
	FSK_DEVIATION_240_kHz = 0xF0
};

enum {
	OUTPUT_POWER_MAX_minus_0dB  = 0x00,
	OUTPUT_POWER_MAX_minus_3dB  = 0x01,
	OUTPUT_POWER_MAX_minus_6dB  = 0x02,
	OUTPUT_POWER_MAX_minus_9dB  = 0x03,
	OUTPUT_POWER_MAX_minus_12dB = 0x04,
	OUTPUT_POWER_MAX_minus_15dB = 0x05,
	OUTPUT_POWER_MAX_minus_18dB = 0x06,
	OUTPUT_POWER_MAX_minus_21dB = 0x07
};

enum {
	DATA_RATE_600_bps   = 0xC7,
	DATA_RATE_1200_bps  = 0xA3,
	DATA_RATE_2400_bps  = 0x91,
	DATA_RATE_4800_bps  = 0x47,
	DATA_RATE_9600_bps  = 0x23,
	DATA_RATE_14400_bps = 0x17,
	DATA_RATE_19200_bps = 0x11,
	DATA_RATE_38400_bps = 0x08
};
enum{
	COM_R04_S01__NOERROR = 0,
	COM_R04_S01__ERROR   = 1,
	COM_R04_S01__TIMEOUT = 2
};

enum {
	CRL   =  6,
	DQD   =  7,
	RSSI  =  8,
	ATS   =  8,
	FFEM  =  9,
	LBD   = 10,
	EXT   = 11,
	WKUP  = 12,
	FFOV  = 13,
	RGUR  = 13,
	POR   = 14,
	FFIT  = 15,
	RGIT  = 15
};
#ifndef IA4420_DEF_FREQ
#define IA4420_DEF_FREQ SUB_BAND_434_0_MHz
#endif

#ifndef IA4420_DEF_BASEBAND_BW
#define IA4420_DEF_BASEBAND_BW BASEBAND_BW_400_kHz
#endif

#ifndef IA4420_DEF_FSK_DEVIATION
#define IA4420_DEF_FSK_DEVIATION FSK_DEVIATION_180_kHz
#endif

#ifndef IA4420_DEF_OUTPUT_POWER
#define IA4420_DEF_OUTPUT_POWER OUTPUT_POWER_MAX_minus_0dB
#endif

#ifndef IA4420_DEF_DATA_RATE
#define IA4420_DEF_DATA_RATE DATA_RATE_9600_bps
#endif

enum {
	IA4420_DEFAULT_FREQ = IA4420_DEF_FREQ,
	IA4420_DEFAULT_OUTPUT_POWER = IA4420_DEF_OUTPUT_POWER,
	IA4420_DEFAULT_DATA_RATE = IA4420_DEF_DATA_RATE,
	IA4420_DEFAULT_FSK_DEVIATION = IA4420_DEF_FSK_DEVIATION,
	IA4420_DEFAULT_BASEBAND_BW = IA4420_DEF_BASEBAND_BW
};

#endif
