/*
 * Author:		Laszlo Siroki
 *
 * Interface for IA4420 specific controls and signals
 */

/**
 * IA4420 Radio Control interface.
 */
interface IA4420Control
{
	command result_t SetFrequency();

	command result_t SetBandwidth();

	command result_t SetDeviation();

	command result_t SetDataRate();

	async command result_t TxMode();

	async command result_t RxMode();

	async command result_t IdleMode();

	command result_t SetTXPower(uint8_t power);	

	command result_t SetRXSensitivity();	

	command result_t SetWakeupTimer();

	command result_t SetLowBattery();

	command result_t SetClockDivider();

}
