interface HPLIA4420Command {
	// Configuration Setting Command
	async command result_t CSC(uint8_t config);

	// Power Management Command
	async command result_t PMC(uint8_t power);

	// Frequency Setting Command
	async command result_t FSC(uint16_t freq);

	// Data Rate Command
	async command result_t DRC(uint8_t rate);

	// Receiver Control Command
	async command result_t RCC(uint16_t rxcontrol);

	// Data Filter Command
	async command result_t DFC(uint8_t filter);

	// FIFO and Reset Mode Command
	async command result_t FRMC(uint8_t mode);

	// Receiver FIFO Read Command
	async command result_t RFRC();

	// Receiver FIFO Read Command result
	async event result_t RFRCDone(uint8_t data);
	
	// AFC Command
	async command result_t AFCC(uint8_t afc);

	// TX Configuration Control Command
	async command result_t TXCCC(uint16_t txcontrol);

	// Transmitter Register Write Command
	async command result_t TRWC(uint8_t data);

	// Wake-Up Timer Command
	async command result_t WUTC(uint8_t m, uint8_t r);

	// Low Duty-Cycle Command
	async command result_t LDCC(uint8_t duty);

	// Low Battery Detector and Microcontroller Clock Divider Command
	async command result_t LBDMCDC(uint8_t setting);
	
	// Status Read Command
	async command result_t SRC();

	// Status Read Command result
	async event result_t SRCDone(uint16_t status);

	async event result_t commandDone();	
}
