// $Id: HPLSpiM.nc,v 1.4 2004/06/10 01:31:50 jpolastre Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/* 
 * Authors: Jaein Jeong, Philip buonadonna
 * Date last modified: $Revision: 1.4 $
 *
 */

/**
 * @author Jaein Jeong
 * @author Philip buonadonna
 *
 * @author Laszlo Siroki
 */

includes hardware;

module HPLSpiM
{
	//provides async command result_t initMaster(); //TODO: SPIControl interface
	provides interface StdControl;
	provides interface ByteSPI;
	provides interface FastSPI;
	
	
}

implementation
{
	uint8_t state;
	enum {
		SPI_FREE = 0,
		SPI_TRANSMITTING = 1
	};
	
	TOSH_SIGNAL(SIG_SPI) {
		register uint8_t dr;
		atomic {
			TOSH_CLR_SYS_LED_PIN();
			cbi(SPCR,SPIE); // Interrupt disabled
			dr = inp(SPDR);
			state = SPI_FREE;
			
			SPCR |= 1<<MSTR;
		}
		signal ByteSPI.rxByte(dr);
	}

	async command result_t ByteSPI.txByte(uint8_t data) {
		result_t ret;
		atomic {
			ret = FAIL;
			if (state == SPI_FREE) {
				state = SPI_TRANSMITTING;
				sbi(SPCR,SPIE); // Interrupt enabled
				outp(data, SPDR);
				TOSH_SET_SYS_LED_PIN();
				ret = SUCCESS;
			}
		}
		return ret;
	}

	// TODO: result_t-re trni!
	async command uint8_t FastSPI.txByte(uint8_t data){
		uint8_t res;
		cbi(SPCR,SPIE); // interrupt disabled
		outp(data,SPDR);
		while (bit_is_clear(SPSR,SPIF));
		res = inp(SPDR);
//		sbi(SPCR,SPIE); // interrupt enabled
		return res;
	}
/*
  async command result_t SpiByteFifo.isBufBusy() {
    return status?SUCCESS:FAILURE;  //bit_is_clear(SPSR,SPIF);
  }

  async command uint8_t SpiByteFifo.readByte() {
    return inp(SPDR);
  }

  async command result_t SpiByteFifo.enableIntr() {
    //sbi(SPCR,SPIE);
    outp(0xC0, SPCR);
    cbi(DDRB, 0);
    call PowerManagement.adjustPower();
    return SUCCESS;
  }

  async command result_t SpiByteFifo.disableIntr() {
    cbi(SPCR, SPIE);
    sbi(DDRB, 0);
    cbi(PORTB, 0);
    call PowerManagement.adjustPower();
    return SUCCESS;
  }
*/
	void SPI_Init(unsigned char cpol, unsigned char cpha, unsigned char lsbf, unsigned char speed)
	{
		DDRB|=0x07; DDRB&=0xf7;  //MOSI SCK SS output, MISO input 
		SPCR = (1<<SPE) | (1<<MSTR) | (cpol<<CPOL) | (cpha<<CPHA) | (lsbf<<DORD);
		if(speed==3 || speed==4 || speed==7) SPCR|= (1<<SPR0);
		if(speed>=5) SPCR|= _BV(SPR1);		
		if(speed==1 || speed==3 || speed==5) SPSR|= (1<<SPI2X);		
	}

	command result_t StdControl.init() {

		SPI_Init(0,0,0,4);
		atomic state = SPI_FREE;
//		sbi(SPCR,SPIE); // Interrupt enabled
		return SUCCESS;
	}

	command result_t StdControl.start() {
		return SUCCESS;
	}

	command result_t StdControl.stop() {
		return SUCCESS;
	}
}
