includes ioboard;

module NumDispM {
	provides {
		interface NumDisp;
		interface StdControl;
	}
	uses {
		interface ByteSPI as SPI;
		//interface FastSPI as FSPI;
		interface BusArbitration;
		//interface Leds4;
	}
}

implementation {
	

	enum {IDLE = 0, WAITING_FOR_BUS, BYTE1, BYTE2, BYTE3 };
	uint8_t state;
	
	norace uint8_t d1,d2,d3;

	command result_t StdControl.init() {
		TOSH_MAKE_GPIO_0_OUTPUT();
		TOSH_SET_GPIO_0_PIN();
		//call initMaster(); //SPI init
		atomic state=IDLE;
		return SUCCESS;
	}

	command result_t StdControl.start(){
		return SUCCESS;
	}

	command result_t StdControl.stop(){
		return SUCCESS;
	}
	
/*
	result_t txByte(uint8_t data_write, uint8_t *data_read)
	{
		outp(data_write,SPDR);
		while (bit_is_clear(SPSR,SPIF));
		if(data_read) *data_read=SPDR;
		return SUCCESS;
	}
*/

	void start_write() {
		atomic state = BYTE1;
		/*  Pulling down the chip select */
		TOSH_CLR_GPIO_0_PIN();
		
		call SPI.txByte(seg_numbers[d1]); // First byte
	
	}
	
	command result_t NumDisp.write_number(int16_t number)
	{
		int8_t lstate;
		atomic {
			lstate=state;
		}
		if (lstate!=IDLE) return FAIL;


		d3=number%10; number/=10;
		d2=number%10; number/=10;
		d1=number%10;

		if (call BusArbitration.getBus()==SUCCESS)
			start_write();
		else
			atomic state = WAITING_FOR_BUS;
		return SUCCESS;
		
	}
	
	async event result_t BusArbitration.busFree() {
		int8_t lstate;
		atomic lstate=state;
		if ((lstate==WAITING_FOR_BUS) && (call BusArbitration.getBus() == SUCCESS))
			start_write();
		return SUCCESS;
	}


 
	async event result_t SPI.rxByte(uint8_t data){
		int8_t lstate;
		atomic {
			lstate=state;
			if (lstate>=BYTE1&&lstate<=BYTE2)
				++state;
			else if(lstate==BYTE3) {
				TOSH_SET_GPIO_0_PIN();
				state=IDLE;
			}
		}
//		call Leds4.set(lstate);
		//post txNextByte();
		switch (lstate)
		{
			case BYTE1: 
				call SPI.txByte(seg_numbers[d2]);
				break;
			case BYTE2: 
				call SPI.txByte(seg_numbers[d3]);
				break;
			case BYTE3:
				call BusArbitration.releaseBus();
				break;
		}
		return SUCCESS;
	}
}
