includes IA4420;

module IA4420SpiM {
	provides interface StdControl;
	provides interface IA4420Spi;
//	uses interface FastSPI;
	uses interface ByteSPI;
	uses interface BusArbitration;
	//uses async command result_t initMaster();

	uses interface Leds4;
	
}


implementation {

	norace uint8_t d1, d2;
	norace uint8_t r1, r2;
	enum {
		IDLE,
		WAITING_FOR_BUS,
		TX_BYTE1,
		TX_BYTE2
	};
	
	uint8_t state;

	command result_t StdControl.init() {
		atomic state=IDLE;
		return SUCCESS;
	}

	command result_t StdControl.start(){
		return SUCCESS;
	}

	command result_t StdControl.stop(){
		return SUCCESS;
	} 
	
	void dotransfer() {
		atomic state = TX_BYTE1;

		TOSH_CLR_IA4420_NSEL_PIN();
		call ByteSPI.txByte(d1); //==SUCCESS
	}

	async event result_t ByteSPI.rxByte(uint8_t data){
		int8_t lstate;
		atomic {
			lstate = state;
			if (lstate==TX_BYTE1) 
				state = TX_BYTE2;
			else if (lstate == TX_BYTE2) {
				TOSH_SET_IA4420_NSEL_PIN();
				state = IDLE;
			}
		}

		if (lstate==TX_BYTE1) {
			r1 = data;
			call ByteSPI.txByte(d2);
		}

		else if(lstate==TX_BYTE2) {
			call BusArbitration.releaseBus();
			r2 = data;
			signal IA4420Spi.receivedResponse(r1, r2);

//			call Leds4.led1Off();
		}
		
		return SUCCESS;
		
	}
/*
	task void signalreceivedresponse() {
		signal IA4420Spi.receivedResponse(r1, r2);
	}
	*/
	command result_t IA4420Spi.sendCommand(uint8_t byte1, uint8_t byte2) {
		int8_t lstate;
		atomic lstate = state;

//		call Leds4.led1On();
		
		if (lstate!=IDLE)
			return FAIL;
		
		d1=byte1;
		d2=byte2;

		atomic state = WAITING_FOR_BUS;

		if (call BusArbitration.getBus() == SUCCESS)
			dotransfer();

		return SUCCESS;
	}

	async event result_t BusArbitration.busFree() {
		int8_t lstate;
		atomic lstate = state;
		if ((lstate==WAITING_FOR_BUS) && (call BusArbitration.getBus() == SUCCESS))
			dotransfer();
		return SUCCESS;
	}

}
