// $Id: CC2420RadioM.nc,v 1.32 2004/06/30 08:00:36 jpolastre Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/*  
 *  Authors: Joe Polastre
 *  Date last modified: $Revision: 1.32 $
 *
 * This module provides the layer2 functionality for the mica2 radio.
 * While the internal architecture of this module is not CC2420 specific,
 * It does make some CC2420 specific calls via CC2420Control.
 * 
 * $Id: CC2420RadioM.nc,v 1.32 2004/06/30 08:00:36 jpolastre Exp $
 */

/**
 * @author Joe Polastre
 * @author Alan Broad, Crossbow
 */

includes byteorder;
includes crc;
includes IA4420;

module IA4420RadioM {
	provides {
		interface StdControl;
		interface BareSendMsg as Send;
		interface ReceiveMsg as Receive;
	}
	uses {
		interface IA4420Spi;
		interface IA4420Control;
		interface Random;

		interface Leds4;
//		interface Debug;
//		interface Timer;
	}
}

implementation {
uint8_t transfer_setting = 0x00;

enum {
    DISABLED_STATE = 0,
	INIT_STATE,
	IDLE_STATE,
	TX_STATE,
	RX_STATE
};

	uint8_t state;
	uint8_t substate;

	uint8_t prev_state;
	
	TOS_MsgPtr txbufptr;  // pointer to transmit buffer
	TOS_MsgPtr rxbufptr;  // pointer to receive buffer
	TOS_Msg RxBuf;	// save received messages
	uint16_t crc;
	
	uint8_t *rxbyteptr;
	
//	uint8_t txlength;

	
	volatile uint8_t sync_done;

//	volatile bool timeout;
	
  ///**********************************************************
  //* local function definitions
  //**********************************************************/
/*
   void sendFailed() {
     atomic stateRadio = IDLE_STATE;
     txbufptr->length = txbufptr->length - MSG_HEADER_SIZE - MSG_FOOTER_SIZE;
     signal Send.sendDone(txbufptr, FAIL);
   }

   inline result_t setInitialTimer( uint16_t jiffy ) {
     stateTimer = TIMER_INITIAL;
     return call BackoffTimerJiffy.setOneShot(jiffy);
   }

   inline result_t setBackoffTimer( uint16_t jiffy ) {
     stateTimer = TIMER_BACKOFF;
     return call BackoffTimerJiffy.setOneShot(jiffy);
   }

   inline result_t setAckTimer( uint16_t jiffy ) {
     stateTimer = TIMER_ACK;
     return call BackoffTimerJiffy.setOneShot(jiffy);
   }
*/

/******************************************************************************
 * PacketRcvd
 * - Radio packet rcvd, signal 
 *****************************************************************************/

	void do_next_rx();
	task void do_next_rx_task();




/*  
  task void PacketSent() {
    TOS_MsgPtr pBuf; //store buf on stack 

    atomic {
      stateRadio = IDLE_STATE;
      txbufptr->time = 0;
      pBuf = txbufptr;
      pBuf->length = pBuf->length - MSG_HEADER_SIZE - MSG_FOOTER_SIZE;
    }

    signal Send.sendDone(pBuf,SUCCESS);
  }
*/
  ///**********************************************************
  //* Exported interface functions
  //**********************************************************/
void wait() {
	uint32_t i;
	for(i=0;i<20000000;i++) ;
}

void wait_for_spi() {
	uint8_t lsync_done = 0;

	while (lsync_done == 0)
		atomic {lsync_done = sync_done;}

	atomic {
		sync_done = 0;
	}

}

void com_r04_s01__Set_Sub_Frequency (uint16_t frequency)
{
	uint8_t d1,d2;
	
	// Frequency Setting command
	d1 = (uint8_t)((frequency & 0xFF00)>>8);
	d2 = (uint8_t)(frequency & 0x00FF);
	
	call IA4420Spi.sendCommand(d1,d2);
	wait_for_spi();
}
 
void com_r04_s01__Set_Baseband_BW (uint8_t baseband)
{
	// Setting the baseband in Receiver controll

	call IA4420Spi.sendCommand(0x96, baseband);
	wait_for_spi();
	
}
void com_r04_s01__Set_Deviation (uint8_t deviation)
{

  // Setting the deviation the bits 0 to 3 contains the PA values 
  // we keeping them
	transfer_setting = ((transfer_setting & 0x0F) | deviation);

	call IA4420Spi.sendCommand(0x98, transfer_setting);
	wait_for_spi();
}

void com_r04_s01__Set_Relative_Output_power (uint8_t power)
{

  // Setting the deviation the bits 4 to 7 contains the deviation
  // values, therefore we keeping them
	transfer_setting = ((transfer_setting & 0xF0) | power);

	call IA4420Spi.sendCommand(0x98, transfer_setting);
	wait_for_spi();
}

void com_r04_s01__Set_Data_rate (uint8_t data_rate)
{

 // Data rate register setting
	call IA4420Spi.sendCommand(0xC6, data_rate);
	wait_for_spi();
}

uint16_t com_r04_s01__Read_Status()
{

	//uint8_t data1,data2;

	call IA4420Spi.sendCommand(0x00, 0x00);
	wait_for_spi();
	//TODO: status!!!
 	//status = (data1<<8)+data2;
	return 0;//status;
}

void do_next_rx();

	
	
	result_t rxMode() {
		uint8_t lstate;
		result_t ret = FAIL;
		atomic {
			lstate = state;
			if (lstate == IDLE_STATE) {
				state = RX_STATE;
				substate=0;
			}
			if(state == RX_STATE)
				ret = SUCCESS;
	
//			timeout = FALSE;
		}

		if (lstate == IDLE_STATE)		
			do_next_rx();

		return ret;
	}


  void com_r04_s01__Init_433 (unsigned int sub_frequency, uint8_t baseband_bw, uint8_t deviation, uint8_t power, uint8_t data_rate)
{


	atomic {
		state = INIT_STATE;
		sync_done = 0;
	}
	
//	__nesc_enable_interrupt();

	
  // Configuration Setting command
	call IA4420Spi.sendCommand(0x80,0xD7); // enables the internal data register, rx fifo, 433 MHz, 12 pF

	wait_for_spi();

	
   // Configuration Setting command again experiences shows that it should be done twice
	call IA4420Spi.sendCommand(0x80,0xD7); // enables the internal data register, rx fifo, 433 MHz, 12 pF
	wait_for_spi();

  
  // Sub frequencies
	com_r04_s01__Set_Sub_Frequency(sub_frequency);
  
  // Power management command
	call IA4420Spi.sendCommand(0x82,0x18);
	wait_for_spi();
  
  // Setting baseband BW
	com_r04_s01__Set_Baseband_BW(baseband_bw);

  // Transmiter Controll command
	com_r04_s01__Set_Deviation (deviation);
	com_r04_s01__Set_Relative_Output_power (power);

  
  // Transmiter Controll command
	com_r04_s01__Set_Data_rate (data_rate);

  // dummy status read for power on reset acknowledgement 
	com_r04_s01__Read_Status();

}

	command result_t StdControl.init() {
		TOSH_MAKE_IA4420_NSEL_OUTPUT();
		TOSH_MAKE_IA4420_NIRQ_INPUT();
		call Leds4.init();
		atomic {
			state = DISABLED_STATE;
			rxbufptr = &RxBuf;
			//rxbufptr->length = 0;
		}
	
		return SUCCESS;
	}
  
	command result_t StdControl.stop() {
		atomic state = DISABLED_STATE;
		return SUCCESS;
	}

  
	task void inittask() {
		com_r04_s01__Init_433(
			SUB_BAND_433_6_MHz,
			BASEBAND_BW_400_kHz,
			FSK_DEVIATION_210_kHz,
			OUTPUT_POWER_MAX_minus_0dB,
			DATA_RATE_2400_bps
			);
		atomic state = IDLE_STATE;
		
		rxMode();
	
	}



	command result_t StdControl.start() {
		
		uint8_t lstate;
		atomic lstate = state;
	
		if (lstate == DISABLED_STATE) {
			post inittask();
		}
		return SUCCESS;
	}

/*
  void sendPacket() {
  
    uint8_t status;

    call HPLChipcon.cmd(CC2420_STXONCCA);
    status = call HPLChipcon.cmd(CC2420_SNOP);
    if ((status >> CC2420_TX_ACTIVE) & 0x01) {
      TOSH_uwait(450);           // ~ 400 usec delay until SFD goes high!!!
      while (TOSH_READ_CC_SFD_PIN()){};  // wait until SFD pin goes low
      atomic stateRadio = POST_TX_STATE;
      if (bAckEnable) {
        if (!(setAckTimer(CC2420_ACK_DELAY)))
          sendFailed();
      }
      else {
        if (!post PacketSent())
          sendFailed();
      }
    }
    else {
      atomic stateRadio = PRE_TX_STATE;
      if (!(setBackoffTimer(signal MacBackoff.congestionBackoff(txbufptr) * CC2420_SYMBOL_UNIT))) {
        sendFailed();
      }
    }
  }
*/
/*
  task void startSend() {
    if (!(call HPLChipcon.cmd(CC2420_SFLUSHTX))) {
      sendFailed();
      return;
    }
    if (!(call HPLChipconFIFO.writeTXFIFO(txlength+1,(uint8_t*)txbufptr))) {
      sendFailed();
      return;
    }
  }
*/

/*
  async event result_t BackoffTimerJiffy.fired() {
    uint8_t currentstate;
    atomic currentstate = stateRadio;

    switch (stateTimer) {
    case TIMER_INITIAL:
      if (!(post startSend())) {
        sendFailed();
      }
      break;
    case TIMER_BACKOFF:
      tryToSend();
      break;
    case TIMER_ACK:
      if (currentstate == POST_TX_STATE) {
        txbufptr->ack = 0;
        post PacketSent();
      }
      break;
    }
    return SUCCESS;
  }
*/

/*
void com_r04_s01__Start_Transmitting ()
{
	
	// Power management command 
	call IA4420Spi.sendCommand(0x82, 0x18); // disable transmitter

	// Power management command 	
	call IA4420Spi.sendCommand(0x82, 0x38); // enable transmitter

}
*/

void com_r04_s01__Write_Transmit_data (uint8_t d)
{
	// Transmit register write command
	call IA4420Spi.sendCommand(0xB8, d);
}

/*
void com_r04_s01__Transmitter_Disable ()
{
	// Power management command
	call IA4420Spi.sendCommand(0x82, 0x18); // disable transmitter
	// syntheser, oscillator on
}
*/


void do_next_tx() {
	uint8_t lsubstate;
	static uint8_t *byteptr, *endbyteptr;
	atomic lsubstate=substate;

	switch(lsubstate)
	{
		case 0:
			byteptr = (uint8_t *) txbufptr;
			//endbyteptr = ((uint8_t *) &(txbufptr->data)) + txbufptr->length;
			//endbyteptr = byteptr + 11;
			endbyteptr = ((uint8_t *)txbufptr) + TOSH_HEADER_LENGTH + txbufptr->length;
			
			txbufptr->crc=0;
			while (byteptr != endbyteptr)
				txbufptr->crc = crcByte(txbufptr->crc, *(byteptr++));

			byteptr = (uint8_t *) txbufptr;
				
			call IA4420Spi.sendCommand(0x82, 0x18); // disable transmitter
			break;
		case 1:
		case 2:
		
			com_r04_s01__Write_Transmit_data (0xAA);
			break;
		case 3:
			call IA4420Spi.sendCommand(0x82, 0x38); // enable transmitter
			break;
		case 4:
		case 5:
		case 6:
		case 7:
		case 8:
		case 9:
			com_r04_s01__Write_Transmit_data (0xAA);
			break;
		
		/*** Sending syncron pattern ***/	
		case 10:
			com_r04_s01__Write_Transmit_data (0x2D);
			break;
		case 11:
			com_r04_s01__Write_Transmit_data (0xD4);
			break;

		case 12:
			if (byteptr != endbyteptr) {
				com_r04_s01__Write_Transmit_data (*byteptr);
				byteptr++;
			} else {
//				atomic substate=53; // Only for testing!!!
//				call IA4420Spi.sendCommand(0x82, 0x18); // disable transmitter

				atomic substate=50;
				com_r04_s01__Write_Transmit_data ((uint8_t)(txbufptr->crc & 0xFF));
//				com_r04_s01__Write_Transmit_data (0);
			}
			break;
		//CRC:
		/*
		case 50:
			com_r04_s01__Write_Transmit_data ((uint8_t)(txbufptr->crc));
			break;
			*/
		case 51:
			com_r04_s01__Write_Transmit_data ((uint8_t)(txbufptr->crc >> 8));
//			com_r04_s01__Write_Transmit_data (0);
			break;

		case 52:
			com_r04_s01__Write_Transmit_data (0);
			break;
			
		case 53:
			if (prev_state == RX_STATE)
				call IA4420Spi.sendCommand(0x82, 0xD8); // disable transmitter, enable receiver
			else 
				call IA4420Spi.sendCommand(0x82, 0x18); // disable transmitter
			break;
			
	}

}

 /**********************************************************
   * Send
   * - Xmit a packet
   *    USE SFD FALLING FOR END OF XMIT !!!!!!!!!!!!!!!!!! interrupt???
   * - If in power-down state start timer ? !!!!!!!!!!!!!!!!!!!!!!!!!s
   * - If !TxBusy then 
   *   a) Flush the tx fifo 
   *   b) Write Txfifo address
   *    
   **********************************************************/

	command result_t Send.send(TOS_MsgPtr pMsg) {
		atomic {
			prev_state = state;
			if (state == IDLE_STATE || state == RX_STATE) {
				state = TX_STATE;
		call Leds4.led4Off();
				substate = 0;
				txbufptr = pMsg;
				//txlength = pMsg->length + offsetof(struct TOS_Msg, data) ; //+CRC
			}
		}

		if (prev_state != IDLE_STATE && prev_state != RX_STATE)
			return FAIL;
	
		  pMsg->addr = toLSB16(pMsg->addr);
		  
		  //countRetry = MAX_SEND_TRIES;
		  //if (setInitialTimer(signal MacBackoff.initialBackoff(txbufptr) * CC2420_SYMBOL_UNIT)) {
		  //  atomic stateRadio = PRE_TX_STATE;
		  //  return SUCCESS;
		  //}
	  
		do_next_tx();
		return SUCCESS;
	}


	task void do_next_tx_task() {
		do_next_tx();
	}
	
	task void wait_for_radio_and_do_next_tx_task() {
		if (TOSH_READ_IA4420_NIRQ_PIN())
			post wait_for_radio_and_do_next_tx_task();
		else
			do_next_tx();
	}

/*
  task void delayedRXFIFO() {
     uint8_t len = MSG_DATA_SIZE;
     call HPLChipconFIFO.readRXFIFO(len,(uint8_t*)rxbufptr);
  }    
*/
  /**********************************************************
   * FIFOP lo Interrupt: Rx data avail in CC2420 fifo
   * Radio must have been in Rx mode to get this interrupt
   * If FIFO pin =lo then fifo overflow=> flush fifo & exit
   * 
   *
   * Things ToDo:
   *
   * -Disable FIFOP interrupt until PacketRcvd task complete 
   * until send.done complete
   *
   * -Fix mixup: on return
   *  rxbufptr->rssi is CRC + Correlation value
   *  rxbufptr->strength is RSSI
   **********************************************************/
/*
   async event result_t HPLChipcon.FIFOPIntr() {

     // if we're trying to send a message and a FIFOP interrupt occurs
     // and acks are enabled, we need to backoff longer so that we don't
     // interfere with the ACK
     if (bAckEnable && (stateRadio == PRE_TX_STATE)) {
       if (call BackoffTimerJiffy.isSet()) {
         call BackoffTimerJiffy.stop();
         call BackoffTimerJiffy.setOneShot((signal MacBackoff.congestionBackoff(txbufptr) * CC2420_SYMBOL_UNIT) + CC2420_ACK_DELAY);
       }
     }

     // THIS SHOULD NEVER HAPPEN-- FIFOP will only be set
     //  if the FIFO contains data -and- is valid     
     if (!TOSH_READ_CC_FIFO_PIN()){
         call HPLChipcon.read(CC2420_RXFIFO);          //flush Rx fifo
         call HPLChipcon.cmd(CC2420_SFLUSHRX);
       return SUCCESS;
     }
     
     post delayedRXFIFO();

     return SUCCESS;
  }

  async event result_t HPLChipconFIFO.RXFIFODone(uint8_t length, uint8_t *data) {
    uint8_t currentstate;
    atomic currentstate = stateRadio;
    // if there's still data in the fifo, must be corrupt, flush it
    if (TOSH_READ_CC_FIFO_PIN()) {
      call HPLChipcon.read(CC2420_RXFIFO);          //flush Rx fifo
      call HPLChipcon.cmd(CC2420_SFLUSHRX);
    }

    // is the packet larger than we can handle?
    if (length > MSG_DATA_SIZE)
      return SUCCESS;

    rxbufptr = (TOS_MsgPtr)data;

    if (bAckEnable && (currentstate == POST_TX_STATE) &&
         ((rxbufptr->fcfhi & 0x03) == CC2420_DEF_FCF_TYPE_ACK) &&
         (rxbufptr->dsn == currentDSN)) {
      atomic {
        txbufptr->ack = 1;
        txbufptr->strength = data[length-2];
        txbufptr->lqi = data[length-1] & 0x7F;
        currentstate = POST_TX_ACK_STATE;
      }
      post PacketSent();
    }

    if ((rxbufptr->fcfhi & 0x03) != CC2420_DEF_FCF_TYPE_DATA)
      return SUCCESS;

    rxbufptr->length = rxbufptr->length - MSG_HEADER_SIZE - MSG_FOOTER_SIZE;
    // adjust destination to the right byte order
    rxbufptr->addr = fromLSB16(rxbufptr->addr);
 
    // if the length is shorter, we have to move the CRC bytes
    rxbufptr->crc = data[length-1] >> 7;
    // put in RSSI
    rxbufptr->strength = data[length-2];
    // put in LQI
    rxbufptr->lqi = data[length-1] & 0x7F;

    post PacketRcvd();	

    return SUCCESS;     
  }

  async event result_t HPLChipconFIFO.TXFIFODone(uint8_t length, uint8_t *data) { 
     tryToSend();
     return SUCCESS;
  }

  async command void MacControl.enableAck() {
    atomic bAckEnable = TRUE;
    call CC2420Control.enableAddrDecode();
    call CC2420Control.enableAutoAck();
  }

  async command void MacControl.disableAck() {
    atomic bAckEnable = FALSE;
    call CC2420Control.disableAddrDecode();
    call CC2420Control.disableAutoAck();
  }

*/

  /**
   * How many basic time periods to back off.
   * Each basic time period consists of 20 symbols (16uS per symbol)
   */
/*
  default async event int16_t MacBackoff.initialBackoff(TOS_MsgPtr m) {
    return (call Random.rand() & 0xF) + 1;
  }
*/
  /**
   * How many symbols to back off when there is congestion (16uS per symbol)
   */
/*
  default async event int16_t MacBackoff.congestionBackoff(TOS_MsgPtr m) {
    return (call Random.rand() & 0xF) + 1;
  }
/*

// Default events for radio send/receive coordinators do nothing.
// Be very careful using these, you'll break the stack.

default async event void RadioSendCoordinator.startSymbol(uint8_t bitsPerBlock, uint8_t offset, TOS_MsgPtr msgBuff) { }
default async event void RadioSendCoordinator.byte(TOS_MsgPtr msg, uint8_t byteCount) { }
default async event void RadioReceiveCoordinator.startSymbol(uint8_t bitsPerBlock, uint8_t offset, TOS_MsgPtr msgBuff) { }
default async event void RadioReceiveCoordinator.byte(TOS_MsgPtr msg, uint8_t byteCount) { }
*/

/*
	async event result_t ByteSPI.rxByte(uint8_t data){
		return SUCCESS;
	}
	*/

void do_next_rx() {
	uint8_t lsubstate;
	//call Leds.set(6);

	atomic lsubstate=substate;

	switch(lsubstate)
	{
		// Switch on receiver
		case 0:

//			call Leds4.led4On();
//	call Leds4.set(1);
			call IA4420Spi.sendCommand(0x82, 0xD8); // RX mode
			break;

		case 1:

			call Leds4.led4On();
//	call Leds4.set(2);

			atomic rxbyteptr = (uint8_t *) rxbufptr;
			call IA4420Spi.sendCommand(0xCA, 0x80); // disable pattern recog
			break;
		case 2:

//	call Leds4.set(3);
			crc=0;
			call IA4420Spi.sendCommand(0xCA, 0x82); // enable pattern recog
			break;

		case 3: // receiving packet
//			atomic timeout = FALSE;
	//		call Timer.start(TIMER_ONE_SHOT, 1000);
		case 4:
		case 5:
			call IA4420Spi.sendCommand(0xB0, 0x00); // read FIFO
			break;

		case 6:
			call IA4420Spi.sendCommand(0xCA, 0x80); // disable pattern recog
			break;		
			
		case 7:
			call IA4420Spi.sendCommand(0x00, 0x00); // Read status
			break;
	 	
	}
}


	task void do_next_rx_task() {
		do_next_rx();
	}
	
	task void wait_for_radio_and_do_next_rx_task() {
	//	call Leds4.set(5);
	
		if (TOSH_READ_IA4420_NIRQ_PIN())
			post wait_for_radio_and_do_next_rx_task();
		else
			do_next_rx();
	}


	task void PacketRcvd() {
		TOS_MsgPtr pBuf;
		
		//call Leds4.set(13);
		
		atomic {
			pBuf = rxbufptr;
		}

				
		pBuf = signal Receive.receive((TOS_MsgPtr)pBuf);
		
		atomic {
			if (pBuf) rxbufptr = pBuf;
		}
		call Leds4.led4Off();
		
		do_next_rx();
	}


	task void signalsenddone() {
		signal Send.sendDone(txbufptr, SUCCESS);
//		call Leds4.led3Off();
	}



	async event result_t IA4420Spi.receivedResponse(uint8_t byte1, uint8_t byte2) {
		uint8_t lstate, lsubstate;
		
		atomic {
			lstate = state;
			lsubstate = substate;
		}


		if (lstate==INIT_STATE) {
			atomic sync_done = 1;

		}
		else if (lstate==TX_STATE) {


			switch(lsubstate)
			{
				case 0:
				case 1:
				case 2:
					substate = lsubstate+1;
					post do_next_tx_task();
//					do_next_tx();
					break;
				case 3:
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();
					break;
				case 4:
				case 5:
				case 6:
				case 7:
				case 8:
				case 9:
		//			com_r04_s01__Write_Transmit_data (0xAA);
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();
					break;
				
				/*** Sending syncron pattern ***/	
				case 10:
		//			com_r04_s01__Write_Transmit_data (0x2D);
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();
					break;
				case 11:
		//			com_r04_s01__Write_Transmit_data (0xD4);
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();
					break;

				case 12:
					post wait_for_radio_and_do_next_tx_task();
					break;

				//CRC:
				case 50:
		//			com_r04_s01__Write_Transmit_data ((uint8_t)(pMsg->crc));
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();

					break;
				case 51:
		//			com_r04_s01__Write_Transmit_data ((uint8_t)(pMsg->crc >> 8));
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_tx_task();
					break;
		
				case 52:
		//			com_r04_s01__Write_Transmit_data (0);
					substate = lsubstate+1;
		post wait_for_radio_and_do_next_tx_task();
//					post do_next_tx_task();
					break;
				case 53:
					post signalsenddone();
					atomic {
						state = prev_state;
						substate=0;
						if (state == RX_STATE)
							post do_next_rx_task();
					}
					break;
					
			}
		
		} else if (lstate==RX_STATE) {
/*
			atomic {
				if (timeout) {
					timeout = FALSE;
					substate = 1;
					post do_next_rx_task();
				}
			}
*/
			switch(substate)
			{
				case 0:
				case 1:
					substate = lsubstate+1;
					post do_next_rx_task();
					break;
				case 2:
					substate = lsubstate+1;
					post wait_for_radio_and_do_next_rx_task(); // wait for sync pattern
					break;
				
				case 3: // receive data
					(*rxbyteptr) = byte2;
					crc = crcByte(crc, byte2);
					
					if ((rxbyteptr == (uint8_t *)(&(rxbufptr->length))) && (rxbufptr->length > TOSH_DATA_LENGTH)) {
						substate = 1;
						post do_next_rx_task();
						break; 						 
					}

					rxbyteptr++;
//	call Leds4.set(7);
					if (rxbyteptr > (uint8_t*)(&(rxbufptr->length)) && 
						rxbyteptr == (uint8_t *)(&(rxbufptr->data)) + rxbufptr->length )// crc
					{
						substate = lsubstate+1;
					}
						//call Leds.set(15);
					
					//if (
					post wait_for_radio_and_do_next_rx_task();
					//!=SUCCESS)
					//	;//call Leds4.led1On();

/*					if (substate==4)
 						;//call Leds.set(10);
					else
						;//call Leds.set(14);
	*/
					break;
				
				case 4: //CRCL
					rxbufptr->crc = byte2;
					substate = lsubstate+1;
	//call Leds4.set(8);
					post wait_for_radio_and_do_next_rx_task();
					break;
				case 5: //CRCH
					rxbufptr->crc += ((uint16_t)byte2)<<8;

					//substate = 1;

					substate = 6;


		//TEST!!!
//		*((uint16_t*)(rxbufptr->data)) = rxbufptr->crc ^ crc;

					//TODO: CRC check
/*
					{
						uint16_t crc = 0;
						uint8_t *ptr = (uint8_t *) rxbufptr;
						uint8_t *eptr = ((uint8_t *)rxbufptr) + TOSH_HEADER_LENGTH + rxbufptr->length;
					
						while (ptr != eptr)
							crc = crcByte(crc, *(eptr++));
						
						if (crc==rxbufptr->crc)
							 rxbufptr->crc = 1;
						else
							 rxbufptr->crc = 0;
					}
*/
				
						if (crc==rxbufptr->crc)
							 rxbufptr->crc = 1;
						else
							 rxbufptr->crc = 0;

//				    rxbufptr->crc = 1;
//	call Leds4.set(9);
//					call Timer.stop(); // Time out lelltsa

					post do_next_rx_task();
					break;
					
				case 6:
					substate = 7;
					post do_next_rx_task();
					break;

				case 7:
					substate = 1;
					post PacketRcvd();
					break;
					
			}
		}
		return SUCCESS;
	}
/*
	event result_t Timer.fired()
	{
//		substate = 1;
//		do_next_rx();
//		atomic timeout = TRUE;
		return SUCCESS;
	}
 */
}





