#ifndef TOSH_IA4420_H
#define TOSH_IA4420_H

TOSH_ALIAS_PIN(IA4420_NSEL, GPIO_13);
TOSH_ALIAS_PIN(IA4420_NIRQ, GPIO_14);
TOSH_ALIAS_PIN(IA4420_SCK, SPI_SCK);
TOSH_ALIAS_PIN(IA4420_SDI, MOSI);
TOSH_ALIAS_PIN(IA4420_SDO, MISO);
enum {
	TOSH_HEADER_LENGTH = offsetof(struct TOS_Msg, data)
};

enum {
	SUB_BAND_433_1_MHz = 0xA4D8,
	SUB_BAND_433_2_MHz = 0xA500,
	SUB_BAND_433_3_MHz = 0xA528,
	SUB_BAND_433_4_MHz = 0xA550,
	SUB_BAND_433_5_MHz = 0xA578,
	SUB_BAND_433_6_MHz = 0xA5A0,
	SUB_BAND_433_7_MHz = 0xA5C8,
	SUB_BAND_433_8_MHz = 0xA5F0,
	SUB_BAND_433_9_MHz = 0xA618,
	SUB_BAND_434_0_MHz = 0xA640,
	SUB_BAND_434_1_MHZ = 0xA668,
	SUB_BAND_434_2_MHz = 0xA690,
	SUB_BAND_434_3_MHz = 0xA6B8,
	SUB_BAND_434_4_MHz = 0xA6E0,
	SUB_BAND_434_5_MHz = 0xA708,
	SUB_BAND_434_6_MHz = 0xA730,
	SUB_BAND_434_7_MHz = 0xA758
};

enum {
	BASEBAND_BW_400_kHz = 0x20,
	BASEBAND_BW_340_kHz = 0x40,
	BASEBAND_BW_270_kHz = 0x60,
	BASEBAND_BW_200_kHz = 0x80,
	BASEBAND_BW_134_kHz = 0xA0,
	BASEBAND_BW_67_kHz  = 0xC0
};

enum {
	FSK_DEVIATION_15_kHz  = 0x00,
	FSK_DEVIATION_30_kHz  = 0x10,
	FSK_DEVIATION_45_kHz  = 0x20,
	FSK_DEVIATION_60_kHz  = 0x30,
	FSK_DEVIATION_75_kHz  = 0x40,
	FSK_DEVIATION_90_kHz  = 0x50,
	FSK_DEVIATION_105_kHz = 0x60,
	FSK_DEVIATION_120_kHz = 0x70,
	FSK_DEVIATION_135_kHz = 0x80,
	FSK_DEVIATION_150_kHz = 0x90,
	FSK_DEVIATION_165_kHz = 0xA0,
	FSK_DEVIATION_180_kHz = 0xB0,
	FSK_DEVIATION_195_kHz = 0xC0,
	FSK_DEVIATION_210_kHz = 0xD0,
	FSK_DEVIATION_225_kHz = 0xE0,
	FSK_DEVIATION_240_kHz = 0xF0
};

enum {
	OUTPUT_POWER_MAX_minus_0dB  = 0x00,
	OUTPUT_POWER_MAX_minus_3dB  = 0x01,
	OUTPUT_POWER_MAX_minus_6dB  = 0x02,
	OUTPUT_POWER_MAX_minus_9dB  = 0x03,
	OUTPUT_POWER_MAX_minus_12dB = 0x04,
	OUTPUT_POWER_MAX_minus_15dB = 0x05,
	OUTPUT_POWER_MAX_minus_18dB = 0x06,
	OUTPUT_POWER_MAX_minus_21dB = 0x07
};

enum {
	DATA_RATE_600_bps   = 0xC7,
	DATA_RATE_1200_bps  = 0xA3,
	DATA_RATE_2400_bps  = 0x91,
	DATA_RATE_4800_bps  = 0x47,
	DATA_RATE_9600_bps  = 0x23,
	DATA_RATE_14400_bps = 0x17,
	DATA_RATE_19200_bps = 0x11,
	DATA_RATE_38400_bps = 0x08
};
enum{
	COM_R04_S01__NOERROR = 0,
	COM_R04_S01__ERROR   = 1,
	COM_R04_S01__TIMEOUT = 2
};

/*
void com_r04_s01__Init_433 (unsigned int sub_frequency, unsigned char baseband_bw, unsigned char deviation, unsigned char power, unsigned char data_rate);
void com_r04_s01__Set_Sub_Frequency (unsigned int frequency);
void com_r04_s01__Set_Baseband_BW (unsigned char baseband);
void com_r04_s01__Set_Deviation (unsigned char deviation);
void com_r04_s01__Set_Relative_Output_power (unsigned char power);
void com_r04_s01__Set_Data_rate (unsigned char data_rate);
unsigned int com_r04_s01__Read_Status (void);
void com_r04_s01__Transmitter_Disable (void);
void com_r04_s01__Start_Transmitting (void);
void com_r04_s01__Write_Transmit_data (unsigned char d);
void com_r04_s01__Send_Packet (unsigned char* buffer, unsigned short int length);
void com_r04_s01__Enable_Receiver (void);
void com_r04_s01__Disable_Receiver (void);

void com_r04_s01__Start_Receiving (void);
unsigned char com_r04_s01__Read_FIFO (void);
unsigned char com_r04_s01__Receiving_Packet (unsigned char* buffer, unsigned short int* length);
unsigned char com_r04_s01__Receiving_Packet_with_timeout (unsigned char* buffer, unsigned short int* length, unsigned short int timeout);
*/


//---------------------------------------------------------------------------------------------------//




#endif
