/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.wizards;

import java.io.File;
import java.io.StringBufferInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewShellWizardPage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;

    public NewShellWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("newTinyosShell", selection);
        this.workbench = workbench;
        this.setTitle("Create the skeleton of a new TinyOS application");
    }

    public boolean finish() {
        String appName = this.getFileName();
        try {
            IFile makefile = this.createFileHandle(this.getContainerFullPath().append("Makefile"));
            this.createFile(makefile, new StringBufferInputStream(this.getMakefileText(appName, this.getContainerFullPath().makeAbsolute().toFile())), (IProgressMonitor)new NullProgressMonitor());
            IFile configFile = this.createFileHandle(this.getContainerFullPath().append(String.valueOf(appName) + ".nc"));
            this.createFile(configFile, new StringBufferInputStream(this.getConfigurationTemplate(appName)), (IProgressMonitor)new NullProgressMonitor());
            IFile moduleFile = this.createFileHandle(this.getContainerFullPath().append(String.valueOf(appName) + "M.nc"));
            this.createFile(moduleFile, new StringBufferInputStream(this.getModuleTemplate(appName)), (IProgressMonitor)new NullProgressMonitor());
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                IDE.openEditor((IWorkbenchPage)page, (IFile)makefile, (boolean)true);
                IDE.openEditor((IWorkbenchPage)page, (IFile)configFile, (boolean)true);
                IDE.openEditor((IWorkbenchPage)page, (IFile)moduleFile, (boolean)true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public String getConfigurationTemplate(String projectName) {
        String configuration = "configuration " + projectName + " {\n" + "}\n" + "implementation {\n" + "\tcomponents Main, " + projectName + "M;\n" + "\tMain.StdControl -> " + projectName + "M.StdControl;\n" + "}\n";
        return configuration;
    }

    public String getModuleTemplate(String projectName) {
        String module = "module " + projectName + "M {\n" + "\tprovides {\n" + "\t\tinterface StdControl;\n" + "\t}\n" + "}\n" + "implementation {\n\n" + "\tcommand result_t StdControl.init() {\n" + "\t\treturn SUCCESS;\n" + "\t}\n" + "\tcommand result_t StdControl.start() {\n" + "\t\treturn SUCCESS;\n" + "\t}\n\n" + "\tcommand result_t StdControl.stop() {\n" + "\t\treturn SUCCESS;\n" + "\t}\n" + "}\n";
        return module;
    }

    public String getMakefileText(String projectName, File directory) {
        System.out.println("get makefile text: " + directory.getAbsolutePath());
        int i = 0;
        File parent = new File(directory.getAbsolutePath());
        while (parent.getParentFile() != null && !this.containsMakerules(parent)) {
            System.out.println(parent);
            parent = parent.getParentFile();
            ++i;
        }
        System.out.println(i);
        String makefile = "COMPONENT=" + projectName + "\n" + "include ";
        int j = 0;
        while (j < i) {
            makefile = String.valueOf(makefile) + "../";
            ++j;
        }
        makefile = String.valueOf(makefile) + "Makerules";
        return makefile;
    }

    private boolean containsMakerules(File dir) {
        return false;
    }
}

