/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.scanner;

import java.util.ArrayList;
import net.tinyos.ide.TinyosColorProvider;
import net.tinyos.ide.scanner.TinyosWhitespaceScanner;
import net.tinyos.ide.scanner.TinyosWordScanner;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;

public class TinyosCodeScanner
extends RuleBasedScanner {
    private static String[] keywords = new String[]{"includes", "interface", "module", "implementation", "configuration", "components", "as", "uses", "provides", "command", "event", "async", "task", "norace", "default", "_attribute_", "atomic", "call", "signal", "post", "auto", "break", "case", "char", "const", "continue", "default", "do", "double", "else", "enum", "extern", "float", "for", "goto", "if", "int", "long", "register", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "void", "volatile", "while"};

    public TinyosCodeScanner(TinyosColorProvider provider) {
        Token keyword = new Token((Object)new TextAttribute(provider.getColor(TinyosColorProvider.KEYWORD), null, 1));
        Token string = new Token((Object)new TextAttribute(provider.getColor(TinyosColorProvider.STRING)));
        Token comment = new Token((Object)new TextAttribute(provider.getColor(TinyosColorProvider.SINGLE_LINE_COMMENT)));
        Token other = new Token((Object)new TextAttribute(provider.getColor(TinyosColorProvider.DEFAULT)));
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("//", (IToken)comment));
        rules.add(new SingleLineRule("\"", "\"", (IToken)string, '\\'));
        rules.add(new SingleLineRule("'", "'", (IToken)string, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new TinyosWhitespaceScanner()));
        WordRule wordRule = new WordRule((IWordDetector)new TinyosWordScanner(), (IToken)other);
        int i = 0;
        while (i < keywords.length) {
            wordRule.addWord(keywords[i], (IToken)keyword);
            ++i;
        }
        rules.add(wordRule);
        IRule[] result = new IRule[rules.size()];
        rules.toArray(result);
        this.setRules(result);
    }
}

