/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.mig;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MigDialog
extends Dialog {
    private String nccOptionsString;
    private String outputFileString;
    private String javaClassnameString;
    private String javaExtendsString;
    private String toolString;
    private String msgFormatFileString;
    private String messageTypeString;
    private Text messageTypeText;
    private Text nccOptionsText;
    private Text outputFileText;
    private Text javaClassnameText;
    private Text javaExtendsText;
    private Text toolText;
    private Text msgFormatFileText;
    private File file;

    public MigDialog(IShellProvider parentShell, File file) {
        super(parentShell);
        this.file = file;
    }

    public MigDialog(Shell parentShell, File file) {
        super(parentShell);
        this.file = file;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Message Interface Generator");
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label nccOptions = new Label(composite, 0);
        nccOptions.setText("ncc Options: ");
        this.nccOptionsText = new Text(composite, 2048);
        Label outputFile = new Label(composite, 0);
        outputFile.setText("Output File (-o): ");
        this.outputFileText = new Text(composite, 2048);
        String filename = this.file.getName();
        String javafilename = String.valueOf(filename.substring(0, filename.lastIndexOf(46))) + ".java";
        this.outputFileText.setText(javafilename);
        Label javaClassname = new Label(composite, 0);
        javaClassname.setText("-java-classname: ");
        this.javaClassnameText = new Text(composite, 2048);
        this.javaClassnameText.setText(filename.substring(0, filename.lastIndexOf(46)));
        Label javaExtends = new Label(composite, 0);
        javaExtends.setText("-java-extends: ");
        this.javaExtendsText = new Text(composite, 2048);
        Label tool = new Label(composite, 0);
        tool.setText("tool: ");
        this.toolText = new Text(composite, 2048);
        this.toolText.setText("java");
        Label msgFormatFile = new Label(composite, 0);
        msgFormatFile.setText("msg-format-file: ");
        this.msgFormatFileText = new Text(composite, 2048);
        this.msgFormatFileText.setText(this.file.getName());
        Label messageType = new Label(composite, 0);
        messageType.setText("message-type: ");
        this.messageTypeText = new Text(composite, 2048);
        this.messageTypeText.setText(filename.substring(0, filename.lastIndexOf(46)));
        return composite;
    }

    protected void okPressed() {
        this.nccOptionsString = this.nccOptionsText.getText();
        this.outputFileString = this.outputFileText.getText();
        this.javaClassnameString = this.javaClassnameText.getText();
        this.javaExtendsString = this.javaExtendsText.getText();
        this.toolString = this.toolText.getText();
        this.msgFormatFileString = this.msgFormatFileText.getText();
        this.messageTypeString = this.messageTypeText.getText();
        super.okPressed();
    }

    public String getJavaClassnameString() {
        return this.javaClassnameString;
    }

    public String getJavaExtendsString() {
        return this.javaExtendsString;
    }

    public String getMessageTypeString() {
        return this.messageTypeString;
    }

    public String getMsgFormatFileString() {
        return this.msgFormatFileString;
    }

    public String getNccOptionsString() {
        return this.nccOptionsString;
    }

    public String getOutputFileString() {
        return this.outputFileString;
    }

    public String getToolString() {
        return this.toolString;
    }
}

