/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.mig;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import net.tinyos.ide.make.OutputThread;
import net.tinyos.ide.mig.MigDialog;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class MigAction
implements IObjectActionDelegate {
    private ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        System.out.println(this.selection.getClass());
        if (this.selection instanceof IStructuredSelection) {
            Iterator it = ((IStructuredSelection)this.selection).iterator();
            while (it.hasNext()) {
                Object element = it.next();
                IFile file = null;
                if (!(element instanceof IFile)) continue;
                file = (IFile)element;
                System.out.println(file.getLocation());
                MigDialog dialog = new MigDialog(Display.getCurrent().getActiveShell(), file.getLocation().toFile());
                dialog.setBlockOnOpen(true);
                if (dialog.open() != 0) continue;
                String migCommand = "cd " + file.getParent().getLocation() + ";";
                String command = "mig " + dialog.getNccOptionsString();
                if (dialog.getOutputFileString() != null && !dialog.getOutputFileString().equals("")) {
                    command = String.valueOf(command) + " -o " + dialog.getOutputFileString();
                }
                if (dialog.getJavaClassnameString() != null && !dialog.getJavaClassnameString().equals("")) {
                    command = String.valueOf(command) + " -java-classname=" + dialog.getJavaClassnameString();
                }
                if (dialog.getJavaExtendsString() != null && !dialog.getJavaExtendsString().equals("")) {
                    command = String.valueOf(command) + " -java-extends=" + dialog.getJavaExtendsString() + " ";
                }
                command = String.valueOf(command) + " " + dialog.getToolString() + " " + dialog.getMsgFormatFileString() + " " + dialog.getMessageTypeString();
                System.out.println(command);
                migCommand = String.valueOf(migCommand) + command;
                if (System.getProperty("os.name").startsWith("Windows")) {
                    migCommand = "bash --login -tic \"" + migCommand + "\"";
                    System.out.println(migCommand);
                }
                try {
                    Process proc = Runtime.getRuntime().exec(migCommand);
                    BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    BufferedReader error = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                    MessageConsole myConsole = null;
                    IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
                    IConsole[] consoles = conMan.getConsoles();
                    int i = 0;
                    while (i < consoles.length) {
                        IConsole console = consoles[i];
                        if (console.getName().equals("tinyos")) {
                            myConsole = (MessageConsole)console;
                        }
                        ++i;
                    }
                    if (myConsole != null) {
                        conMan.removeConsoles(new IConsole[]{myConsole});
                    }
                    myConsole = new MessageConsole("tinyos", null);
                    conMan.addConsoles(new IConsole[]{myConsole});
                    MessageConsoleStream outStream = myConsole.newMessageStream();
                    OutputThread t = new OutputThread(input, outStream);
                    t.start();
                    OutputThread err = new OutputThread(error, outStream);
                    err.start();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

