/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.make;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.tinyos.ide.make.ErrorThread;
import net.tinyos.ide.make.OutputThread;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class WindowsMake {
    private final File directory;
    private final String target;
    private final String[] extras;

    public WindowsMake(File directory, String target, String[] extras) {
        this.directory = directory;
        this.target = target;
        this.extras = extras;
    }

    public void make() {
        try {
            String execCommand = "make " + this.target + " ";
            int i = 0;
            while (i < this.extras.length) {
                execCommand = String.valueOf(execCommand) + this.extras[i] + " ";
                ++i;
            }
            execCommand = String.valueOf(execCommand) + "--no-print-directory --directory=";
            execCommand = "bash --login -tic \"" + execCommand;
            String path = "/cygdrive/" + this.directory.toString().charAt(0) + this.directory.toString().replace('\\', '/').substring(2);
            String correct = "";
            int i2 = 0;
            while (i2 < path.length()) {
                correct = path.charAt(i2) != ' ' ? String.valueOf(correct) + path.charAt(i2) : String.valueOf(correct) + "\\" + path.charAt(i2);
                ++i2;
            }
            execCommand = String.valueOf(execCommand) + correct + "\"";
            try {
                Process proc = Runtime.getRuntime().exec(execCommand);
                BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                MessageConsole myConsole = null;
                IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
                IConsole[] consoles = conMan.getConsoles();
                int i3 = 0;
                while (i3 < consoles.length) {
                    IConsole console = consoles[i3];
                    if (console.getName().equals("tinyos")) {
                        myConsole = (MessageConsole)console;
                    }
                    ++i3;
                }
                if (myConsole != null) {
                    conMan.removeConsoles(new IConsole[]{myConsole});
                }
                myConsole = new MessageConsole("tinyos", null);
                conMan.addConsoles(new IConsole[]{myConsole});
                MessageConsoleStream outStream = myConsole.newMessageStream();
                OutputThread t = new OutputThread(input, outStream);
                t.start();
                ErrorThread err = new ErrorThread(error, outStream, this.directory.toString());
                err.start();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

