/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.make;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import net.tinyos.ide.make.ErrorThread;
import net.tinyos.ide.make.OutputThread;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LinuxMake {
    private final File directory;
    private final String target;
    private final String[] extras;

    public LinuxMake(File directory, String target, String[] extras) {
        this.directory = directory;
        this.target = target;
        this.extras = extras;
    }

    public void make() {
        try {
            String execCommand = "make " + this.target + " ";
            int i = 0;
            while (i < this.extras.length) {
                execCommand = String.valueOf(execCommand) + this.extras[i] + " ";
                ++i;
            }
            execCommand = String.valueOf(execCommand) + "--no-print-directory --directory=";
            String path = this.directory.toString();
            execCommand = String.valueOf(execCommand) + path;
            System.out.println(execCommand);
            try {
                Process proc = Runtime.getRuntime().exec(execCommand);
                BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                BufferedReader error = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
                MessageConsole myConsole = null;
                IConsoleManager conMan = ConsolePlugin.getDefault().getConsoleManager();
                IConsole[] consoles = conMan.getConsoles();
                int i2 = 0;
                while (i2 < consoles.length) {
                    IConsole console = consoles[i2];
                    if (console.getName().equals("tinyos")) {
                        myConsole = (MessageConsole)console;
                    }
                    ++i2;
                }
                if (myConsole != null) {
                    conMan.removeConsoles(new IConsole[]{myConsole});
                }
                myConsole = new MessageConsole("tinyos", null);
                conMan.addConsoles(new IConsole[]{myConsole});
                conMan.showConsoleView((IConsole)myConsole);
                MessageConsoleStream outStream = myConsole.newMessageStream();
                OutputThread t = new OutputThread(input, outStream);
                t.start();
                ErrorThread err = new ErrorThread(error, outStream, this.directory.toString());
                err.start();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

