/*
 * Decompiled with CFR 0.152.
 */
package net.tinyos.ide.make;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.ui.console.MessageConsoleStream;

public class ErrorThread
extends Thread {
    private BufferedReader input;
    private MessageConsoleStream output;
    private String makeDirectory;

    public ErrorThread(BufferedReader error, MessageConsoleStream stream, String makeDirectory) {
        this.input = error;
        this.output = stream;
        this.makeDirectory = makeDirectory;
    }

    public void run() {
        try {
            try {
                ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("net.tinyos.ide.TinyosError", true, 2);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            String line = this.input.readLine();
            while (line != null) {
                File errorFile;
                this.output.println(line);
                StringTokenizer str = new StringTokenizer(line, ":");
                String firstToken = null;
                if (str.hasMoreTokens()) {
                    firstToken = str.nextToken();
                }
                String secondToken = null;
                if (str.hasMoreTokens()) {
                    secondToken = str.nextToken();
                }
                String thirdToken = null;
                if (str.hasMoreTokens()) {
                    thirdToken = str.nextToken();
                }
                if ((errorFile = new File(this.makeDirectory, firstToken)).exists()) {
                    System.out.println(errorFile.toString());
                    IFile error = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(errorFile.toString()));
                    try {
                        IMarker marker = error.createMarker("net.tinyos.ide.TinyosError");
                        System.out.println(marker.exists());
                        marker.setAttribute("severity", 2);
                        if (secondToken != null) {
                            try {
                                int lineNo = Integer.parseInt(secondToken);
                                marker.setAttribute("lineNumber", lineNo);
                                if (thirdToken != null) {
                                    marker.setAttribute("message", (Object)thirdToken);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                marker.setAttribute("message", (Object)secondToken);
                            }
                        }
                        System.out.println(marker.toString());
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                } else if (firstToken != null) {
                    try {
                        IMarker marker = ResourcesPlugin.getWorkspace().getRoot().createMarker("net.tinyos.ide.TinyosError");
                        System.out.println(marker.exists());
                        marker.setAttribute("severity", 2);
                        marker.setAttribute("message", (Object)firstToken);
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                }
                line = this.input.readLine();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

