#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package TextGeneratorFactory;
@EXPORT = qw(createTextGenerator getLangToPict);

use strict;
use warnings;
use Switch;

my %langToPict = (
    hungarian => "hu",    
    english => "gb",
    german => "de",
#    spanish => "es",
    italian => "it",    
    french => "fr",
    polish => "pl",
#    slovenian => "si",
#    japanese => "jp",
#    chinese => "cn",
);
sub getLangToPict {
  return %langToPict;
}
sub createTextGenerator {
  my ( $language ) = @_;
  switch ($language) {
    case "hu" {
      require TextGenerators::HungarianTextGenerator; 
      return HungarianTextGenerator->new( ); 
      }
    case "gb" {
      require TextGenerators::EnglishTextGenerator; 
      return EnglishTextGenerator->new( ); 
      }
    case "de" {
      require TextGenerators::GermanTextGenerator; 
      return GermanTextGenerator->new( ); 
      }
    case "fr" {
      require TextGenerators::FrenchTextGenerator; 
      return FrenchTextGenerator->new( ); 
      }
    case "pl" {
      require TextGenerators::PolishTextGenerator; 
      return PolishTextGenerator->new( ); 
      }
    case "it" {
      require TextGenerators::ItalianTextGenerator; 
      return ItalianTextGenerator->new( ); 
      }
    else {
      require TextGenerators::EnglishTextGenerator;
      EnglishTextGenerator->new( );
      }
  } 
}

1;
