#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package Person;
use strict;
use warnings;
use Params::Validate qw(:all);
use Name;

use Class::Std::Storable;
{
  my %id_of               : ATTR(:name<id>);
  my %name_of             : ATTR(:get<name> :set<name>);
  my %gender_of           : ATTR(:get<gender> :set<gender>);   #0 for male, 1 for female
  my %father_of           : ATTR(:get<father> :set<father>);
  my %mother_of           : ATTR(:get<mother> :set<mother>);
  my %email_of            : ATTR(:get<email> :set<email>);
  my %homepage_of         : ATTR(:get<homepage> :set<homepage>);
  my %date_of_birth_of    : ATTR(:get<date_of_birth> :set<date_of_birth>);          
  my %date_of_death_of    : ATTR(:get<date_of_death> :set<date_of_death>);
  my %is_living_of        : ATTR(:get<is_living> :set<is_living>);   #1 for living, 0 for dead
  my %place_of_birth_of   : ATTR(:get<place_of_birth> :set<place_of_birth>);
  my %place_of_death_of   : ATTR(:get<place_of_death> :set<place_of_death>);
  my %cemetery_of         : ATTR(:get<cemetery> :set<cemetery>);  # see Cemetery.pm      
  my %schools_of          : ATTR(:get<schools> :set<schools>);     #ARRAYREF of strings
  my %jobs_of             : ATTR(:get<jobs> :set<jobs>);              #ARRAYREF of strings
  my %work_places_of      : ATTR(:get<work_places> :set<work_places>);      
  my %places_of_living_of : ATTR(:get<places_of_living> :set<places_of_living>);
  my %general_of          : ATTR(:get<general> :set<general>);
  my %default_picture_of  : ATTR(:get<default_picture> :set<default_picture>);      
}
1;