#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package FamilyTreeData;
use strict;
use warnings;
use Person;
use DataParsers::FieldValidatorParser;
use Params::Validate qw(:all);
use Set::Scalar;
use CGI::Carp qw(fatalsToBrowser warningsToBrowser);

sub new {
  my ( $classname) = @_;
  my $self = {
    people   => {},  #hash of Person
    children => {}   #hash of childres's array
  };
  return bless $self, $classname;
}
sub add_person {
  my ($self) = shift;
  my (%arg_ref) = validate(@_, { id => {type => SCALAR},
    first_name => {type => SCALAR|UNDEF, default => undef },
    mid_name   => {type => SCALAR|UNDEF, default => undef},
    last_name  => {type => SCALAR|UNDEF, default => undef},
    title      => {type => SCALAR|UNDEF, default => undef},
    prefix     => {type => SCALAR|UNDEF, default => undef},
    suffix     => {type => SCALAR|UNDEF, default => undef},
    nickname   => {type => SCALAR|UNDEF, default => undef},
    father_id  => {type => SCALAR|UNDEF, default => undef},
    mother_id  => {type => SCALAR|UNDEF, default => undef},
    email      => {type => SCALAR|UNDEF, default => undef},
    homepage   => {type => SCALAR|UNDEF, default => undef},
    date_of_birth=> {type => SCALAR|UNDEF, default => undef},
    date_of_death=> {type => SCALAR|UNDEF, default => undef},
    gender     => {type => SCALAR|UNDEF, default => undef},
    is_living  => {type => SCALAR|UNDEF, default => undef},
    place_of_birth => {type => SCALAR|UNDEF, default => undef},
    place_of_death => {type => SCALAR|UNDEF, default => undef},
    cemetery   => {type => SCALAR|UNDEF, default => undef},
    schools    => {type => ARRAYREF|UNDEF, default => undef},
    jobs       => {type => ARRAYREF|UNDEF, default => undef},
    work_places => {type => ARRAYREF|UNDEF, default => undef},
    places_of_living => {type => SCALAR|UNDEF, default => undef},
    general    => {type => SCALAR|UNDEF, default => undef} });
    
  if(!FieldValidatorParser::validIDEntry($arg_ref{id})) {
    warn "Not valid Id: " . $arg_ref{id} . " Ids should not contain "
      . "only alphanumeric plus underscore character";
    return; 
  }
  
  $self->{people}{ $arg_ref{id} } = Person->new( {id => $arg_ref{id}} )
    if ( !defined $self->{people}{ $arg_ref{id} } );
  my $temp_person = $self->{people}{ $arg_ref{id} };
  
  $temp_person->set_name(Name->new(
          {first_name => $arg_ref{first_name},
           mid_name   => $arg_ref{mid_name},
           last_name  => $arg_ref{last_name}}));
  $temp_person->get_name()->set_title($arg_ref{title})
    if(defined $arg_ref{title});
  $temp_person->get_name()->set_prefix($arg_ref{prefix})
    if(defined $arg_ref{prefix});
  $temp_person->get_name()->set_suffix($arg_ref{suffix})
    if(defined $arg_ref{suffix});
  $temp_person->get_name()->set_nickname($arg_ref{nickname})
    if(defined $arg_ref{nickname});
    
  if(FieldValidatorParser::validIDEntry($arg_ref{father_id})) {
    $self->{people}{ $arg_ref{father_id} } = 
      Person->new( {id => $arg_ref{father_id}} )
        if ( !defined $self->{people}{ $arg_ref{father_id} } );
    my $father = $self->{people}{ $arg_ref{father_id} };
    $temp_person->set_father( $father );
    if(!defined $father->get_gender()) {
      $father->set_gender(0);
    } else {
        warn("Incorrent gender for " . $father->get_id())
          if($father->get_gender() != 0);
    }
    push @{ $self->{children}{$arg_ref{father_id}}}, $temp_person;
   } 
   
   # this should be refactored into a function!
  if(FieldValidatorParser::validIDEntry($arg_ref{mother_id})) {
    $self->{people}{ $arg_ref{mother_id} } = 
      Person->new( {id => $arg_ref{mother_id}} )
        if ( !defined $self->{people}{ $arg_ref{mother_id} } );
    my $mother = $self->{people}{ $arg_ref{mother_id} };
    $temp_person->set_mother( $mother );
    if(!defined $mother->get_gender()) {
      $mother->set_gender(1);
    } else {
      warn "Incorrent gender for " . $mother->get_id()
        if($mother->get_gender() != 1);
    }
    push @{ $self->{children}{$arg_ref{mother_id}}}, $temp_person;
  }

  if(defined $arg_ref{email} && $arg_ref{email} ne "") {
    if(FieldValidatorParser::validEmail($arg_ref{email})) {
      $temp_person->set_email($arg_ref{email});      
    } else {
      warn "Not valid email: " . $arg_ref{email};
    }
  }
   
  if(defined $arg_ref{homepage} && $arg_ref{homepage} ne "") {
    if(FieldValidatorParser::validURL($arg_ref{homepage})) {
      $temp_person->set_homepage($arg_ref{homepage});      
    } else {
      warn "Not valid url: " . $arg_ref{homepage};
    }
  }   

   $temp_person->set_date_of_birth(FieldValidatorParser::getDate($arg_ref{date_of_birth}))
     if ( defined $arg_ref{date_of_birth} 
      && FieldValidatorParser::getDate($arg_ref{date_of_birth}) );
   $temp_person->set_date_of_death(FieldValidatorParser::getDate($arg_ref{date_of_death}))
     if ( defined $arg_ref{date_of_death}
      && FieldValidatorParser::getDate($arg_ref{date_of_death}) );
     
  if(defined $arg_ref{gender} && $arg_ref{gender} ne "") {
    if(FieldValidatorParser::validBool($arg_ref{gender})) {
      $temp_person->set_gender($arg_ref{gender});      
    } else {
      warn "Not valid bool: " . $arg_ref{gender};
    }
  }
  
  if(defined $arg_ref{is_living} && $arg_ref{is_living} ne "") {
    if(FieldValidatorParser::validBool($arg_ref{is_living})) {
      $temp_person->set_is_living($arg_ref{is_living});      
    } else {
      warn "Not valid bool: " . $arg_ref{is_living};
    }
  }

   my $place = FieldValidatorParser::getPlace($arg_ref{place_of_birth});
   $temp_person->set_place_of_birth($place)
     if(defined $arg_ref{place_of_birth});
     
   $place = FieldValidatorParser::getCemetery($arg_ref{cemetery});
   $temp_person->set_cemetery($place)	if(defined $place);           
   $temp_person->set_schools($arg_ref{schools})
     if(defined $arg_ref{schools});        
   $temp_person->set_jobs($arg_ref{jobs})
     if(defined $arg_ref{jobs});
   $temp_person->set_work_places($arg_ref{work_places})
     if(defined $arg_ref{work_places});
   $temp_person->set_places_of_living(
     FieldValidatorParser::getPlacesArray($arg_ref{places_of_living}))
       if(defined $arg_ref{places_of_living});
   $temp_person->set_general($arg_ref{general})
     if(defined $arg_ref{general});  
}

#######################################################
# returns the no. children of this person
sub numChildren {
  my ($self, $person) = @_;
  if (defined $self->{children}{ $person->get_id() }) {
    return ( scalar @{ $self->{children}{ $person->get_id() } } );
  }
  else {
    return 0;
  }
}

sub node_defined {
  my ( $self, $id ) = @_;
  if( defined $self->{children}{ $id } ) {
    return 1;
  }
  else {
    return 0;
  }
}

sub get_father_full_name {
  my ( $self, $id ) = @_;
  if( defined $self->{people}{ $id }->get_father() ) {
  	return $self->{people}{ $id }->get_father()->get_name()->full_name();
  }
  else {
    return "UNKNOWN";
  }
}

sub get_mother_full_name {
  my ( $self, $id ) = @_;
  if( defined $self->{people}{ $id }->get_mother() ) {
  	return $self->{people}{ $id }->get_mother()->get_name()->full_name();
  }
  else {
    return "UNKNOWN";
  }
}
sub get_spouses {
  my ($self, $person) = @_;
  my $spouse_set = Set::Scalar->new;
  my $parent_1;
  my $parent_2;
  if($person->get_gender() == 0){       # male
    $parent_1 = \&Person::get_father;
    $parent_2 = \&Person::get_mother;
  } else {
    $parent_1 = \&Person::get_mother;
    $parent_2 = \&Person::get_father;
  }
  
  foreach my $child (@{$self->{children}{$person->get_id()}}) {
    $spouse_set->insert($parent_2->($child))
      if($parent_1->($child) == $person && defined $parent_2->($child));
  }
  return $spouse_set;
}
sub get_peers {
  my ( $self, $person ) = @_;
  if (defined $person->get_mother()) {
    return grep { (!defined $_->get_father() && !defined $person->get_father()) ||
                  ($_->get_father() == $person->get_father())} 
      @{$self->{children}{$person->get_mother()->get_id()}};
  }
  elsif (defined $person->get_father()) {
    return grep { !defined $_->get_mother() } 
      @{$self->{children}{$person->get_father()->get_id()}};
  }
  else {
    return ($person);
  }  
}
sub get_soft_peers {
  my ( $self, $person, $parent_type ) = @_;
  
  my $parent_func;
  my $other_parent_func;
  if( $parent_type eq "mother" ) {
    $parent_func = \&Person::get_mother;
    $other_parent_func = \&Person::get_father;
  } else {
    $parent_func = \&Person::get_father;
    $other_parent_func = \&Person::get_mother;
  }
  
  if ( defined $parent_func->($person) ) {
    grep {(!defined $other_parent_func->($_) && defined $other_parent_func->($person)) ||
          (defined $other_parent_func->($_) && !defined $other_parent_func->($person)) ||
          (defined $other_parent_func->($_) && defined $other_parent_func->($person) && 
           $other_parent_func->($_) != $other_parent_func->($person)) } 
      @{$self->{children}{$parent_func->($person)->get_id()}};
  }
  else{
    return ();
  }
}



1;