#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package GedcomFormat;
use strict;
use warnings;
use Gedcom;
use DataParsers::FieldValidatorParser;
use FamilyTreeData;
use CGI::Carp qw(fatalsToBrowser);

my %genderTogedcomsex = (
  U => undef,
  F => 1,
  M => 0,
);
 
sub createFamilyTreeDataFromFile {
  my ($config_) = @_;
  my $file_name = $config_->{file_name} or die "No file_name is given in config";

  my $ged = Gedcom->new(gedcom_file  => $file_name);
  my $family_tree_data = FamilyTreeData->new();                        
  for my $i ($ged->individuals)
  {
    $family_tree_data->add_person({
          id => $i->{xref},
          first_name => $i->given_names(0),
          mid_name   => undef,
          last_name  => $i->surname,
          father_id  => (defined $i->father) ? $i->father->{xref} : undef,
          mother_id  => (defined $i->mother) ?$i->mother->{xref} : undef,
          email      => getEmail($i),
          homepage   => getHomepage($i),
          date_of_birth => getDate("birth date", $i),          
          date_of_death => getDate("death date", $i),
          gender     => $genderTogedcomsex{$i->sex()},
          place_of_birth => getPlace("birth place", $i),
          place_of_death => getPlace("death place", $i),
          cemetery   => getPlace("burial place",$i),
    })
   }
  return $family_tree_data;                         
}

sub getDate {
  my ($date_type, $i) = @_;
    my $date = $i->get_value($date_type);
    if(defined $date) {
      $date = (split(/, /, $date))[-1];
      $date =~ tr/[ ]/[\/]/;
      return $date;       
    }
    return undef;
}
sub getPlace {
  my ($place_type, $i) = @_;
  my $cemetery = $i->get_value($place_type);
  if(defined $cemetery) {
    $cemetery =~ s/,/" "/g;
    $cemetery =~ s/^/"/g;
    $cemetery =~ s/$/"/g;
  }
  return undef;
}
sub getEmail {
  my ($i) = @_;
  my @data = $i->get_value("Object File");
  my @emails = grep {defined $_ && FieldValidatorParser::validEmail($_)} @data; 
  return $emails[0];

}
sub getHomepage {
  my ($i) = @_;
  my @data = $i->get_value("Object File");
  my @urls = grep {defined $_ && FieldValidatorParser::validURL($_)} @data; 
  return $urls[0];

}

1;