#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package ExtendedSimonWardFormat;

require DataParsers::ArrayImporters::CSVArrayImporter;
use strict;
use warnings;
use Person;
use Picture;
use FamilyTreeData;
use Params::Validate qw(:all);
use StringUtils;
use Switch;
use DataParsers::FieldValidatorParser;
use CGI::Carp qw(fatalsToBrowser warningsToBrowser);

my $picture_directory;

sub getID {
  my ($name_with_space) = @_;
  $name_with_space =~ s/ /_/g;
  return $name_with_space;
}

sub getNameFields {
  my ( $full_name ) = @_;
  $full_name =~ s/[0-9]//g;
  my @full_name_a = split( / /, $full_name );
  my $mid_name = join( ' ', @full_name_a[ 1 .. $#full_name_a - 1 ] )
    if(@full_name_a > 2);
  return { first_name => $full_name_a[0], 
           mid_name => $mid_name, 
           last_name => $full_name_a[-1] };
}

sub fill_up_pictures {
  my($family_tree_data) = @_;
  while ( my ($id, $person) = each %{$family_tree_data->{people}}) {
    my $picture_file_name = getPictureFileName(getFileName($id), $picture_directory);
      $person->set_default_picture(Picture->new({file_name => $picture_file_name, 
                                                 comment => ""})) 
        if(defined $picture_file_name); 
  }  
}
sub getPictureFileName{
	my($id) = @_;
	
	if(-e "$picture_directory/$id.jpg" ) {
		return "$id.jpg";
	}
	elsif(-e "$picture_directory/$id.gif" ) {
		return "$id.gif";
	}
	elsif(-e "$picture_directory/$id.tif" ) {
		return "$id.tif";
	}
	elsif(-e "$picture_directory/$id.png" ) {
		return "$id.png"; {
    
  }
	}
	else {
		return;
	}	
}
sub set_parent {
  my ($field, $family_tree_data, $temp_person, $parent_type, $parent_type_code) = @_;
  
  if ( defined $field && FieldValidatorParser::validIDEntry($field) ) {
        my $parent_id = getID( $field );
        if ( !defined $family_tree_data->{people}{$parent_id} ) {
          my $parent = Person->new({id => $parent_id}); 
          $family_tree_data->{people}{$parent_id} = $parent;            
          $parent->set_name(Name->new(getNameFields($field)));
        } 
        my $a_parent = $family_tree_data->{people}{$parent_id};
        push @{ $family_tree_data->{children}{$parent_id}}, $temp_person;
        
        if( $parent_type eq "father") {
          $temp_person->set_father($a_parent);
        } else {
          $temp_person->set_mother($a_parent);
        }
        
        if( defined $a_parent->get_gender() && 
            $a_parent->get_gender() != $parent_type_code ){
          warn "Incorrent gender for ", $a_parent->full_name(), "!?!\n";
        }
        else {
          $a_parent->set_gender($parent_type_code);
        }
   }
}
#sub getPicture {
#  my ($field) = @_;
#  $field = StringUtils::trim($field);
#  if($field =~ /(\S.+\.(jpg|JPG|png|PNG|gif|GIF|tif|TIF))\s+"(\S.*)/) {
#    return Picture->new($picture_directory.$1, $3);
#  }
#  else {
#    print "Nonvalid picture entry: ". $field. 
#      "\nIt should be like Bart_Simpson.jpg \"When I was 10 years old\"\n".
#      "Picture consist of two mandatory parts, i.e. a filename and a comment.".
#      "Comment has to be put between two quotation marks.";
#  }
#}
#sub getPicturesArray {
#  my ($field) = @_;
#  my @pair_array = split(/",/, $field);
#  my @pictures_array;
#  for my $a_picture (@pair_array) {
#    my $picture = getPicture($a_picture);
#    push @pictures_array, $picture if(defined $picture);
#  }
#  return \@pictures_array;
#}
#
sub setPictureDirectory {
  my ($picture_directory_) = @_;
  $picture_directory = $picture_directory_;
}
# return: 0, in case of file open error
sub createFamilyTreeDataFromFile {
  my ($config_) = @_;
  my $file_name = $config_->{file_name} or die "No file_name is given in config";

  my $family_tree_data = FamilyTreeData->new();
  my $arrayImporter = CSVArrayImporter->new($file_name);
  while ($arrayImporter->hasNext()) {
    my @fields = $arrayImporter->next();
    if ( FieldValidatorParser::validIDEntry($fields[0]) ) {
      @fields = map {StringUtils::trim($_)} @fields;
      $family_tree_data->{people}{ getID($fields[0]) } = Person->new( {id => getID( $fields[0] )} )
        if ( !defined $family_tree_data->{people}{ getID( $fields[0] ) } );
      my $temp_person = $family_tree_data->{people}{ getID( $fields[0] ) };
      $temp_person->set_name( Name->new(getNameFields($fields[0])) ) ;
      set_parent($fields[1], $family_tree_data, $temp_person, "father", 0);
      set_parent($fields[2], $family_tree_data, $temp_person, "mother", 1);
      $temp_person->set_email($fields[3])  
      	if(FieldValidatorParser::validEmail($fields[3]));
      $temp_person->set_homepage($fields[4])  
      	if(FieldValidatorParser::validURL($fields[4]));
      if ( defined $fields[5] ) {
        my ( $date_of_birth, $date_of_death ) = split( /-/, $fields[5], 2 );
        $temp_person->set_date_of_birth( FieldValidatorParser::getDate($date_of_birth) ) 
          if ( defined $date_of_birth && $date_of_birth ne "" );
        $temp_person->set_date_of_death( FieldValidatorParser::getDate($date_of_death) )
          if ( defined $date_of_death && $date_of_death ne "");
      }
      $temp_person->set_gender($fields[6]) 
        if( FieldValidatorParser::validBool($fields[6]));
      $temp_person->get_name()->set_title($fields[7])
        if(defined $fields[7]);
      $temp_person->get_name()->set_prefix($fields[8])
        if(defined $fields[8]);
      $temp_person->get_name()->set_suffix($fields[9])
        if(defined $fields[9]);
      $temp_person->get_name()->set_nickname($fields[10])
        if(defined $fields[10]);
      $temp_person->set_is_living($fields[11])
        if( FieldValidatorParser::validBool($fields[11]));
      my $place = FieldValidatorParser::getPlace($fields[12]);
      $temp_person->set_place_of_birth($place)
          if(defined $place);
      $place = FieldValidatorParser::getPlace($fields[13]);
      $temp_person->set_place_of_death($place)
          if(defined $place);
      $place = FieldValidatorParser::getCemetery($fields[14]);
      $temp_person->set_cemetery($place)
        if(defined $place);           
      $temp_person->set_schools([split( /,/, $fields[15] )])
        if(defined $fields[15]);        
      $temp_person->set_jobs([split( /,/, $fields[16] )])
        if(defined $fields[16]);
      $temp_person->set_work_places([split( /,/, $fields[17] )])
        if(defined $fields[17]);
      $temp_person->set_places_of_living(FieldValidatorParser::getPlacesArray($fields[18]))
        if(defined $fields[18]);
      $temp_person->set_general($fields[19])
        if(defined $fields[19]);        
#      $temp_person->set_default_picture(getPicture($fields[20]))
#        if(defined $fields[20]);
#      $temp_person->set_pictures(getPicturesArray($fields[21]))
#        if(defined $fields[21]);
    }
    else {
      warn "First column of a row is not a valid ID. Row: @fields ignored!\n";
    }
  }
  $arrayImporter->close();
  if (defined $config_->{photo_dir}) {
    setPictureDirectory($config_->{photo_dir});
    fill_up_pictures($family_tree_data);
  }
  
  
  return $family_tree_data;
}

#######################################################
# converts a name to a filename
# (converts spaces, converts case)
# CHANGE: we dont remove middle name: $newname =~ s/ .* / /;
#
sub getFileName {
  my ($id) = @_;
  $id =~ s/ /_/g;
  $id =~ tr/A-Z/a-z/;
#  $id =~ tr/[á,é,ó,ö,ő,ú,ü,ű,í,Á,É,Ó,Ö,Ő,Ú,Ü,Ű,Í]/
#            [a,e,o,o,o,u,u,u,i,a,e,o,o,o,u,u,u,i]/; #IT DOES NOT WORK?!?
            
# This works:        
  $id =~ s/á/a/g;
  $id =~ s/ä/a/g;
  $id =~ s/é/e/g;
  $id =~ s/ó/o/g;
  $id =~ s/ö/o/g;
  $id =~ s/ő/o/g;
  $id =~ s/ú/u/g;
  $id =~ s/ü/u/g;
  $id =~ s/ű/u/g;
  $id =~ s/í/i/g;
  $id =~ s/Á/a/g;
  $id =~ s/É/e/g;
  $id =~ s/Ó/o/g;
  $id =~ s/Ö/o/g;
  $id =~ s/Ő/o/g;
  $id =~ s/Ú/u/g;
  $id =~ s/Ü/u/g;
  $id =~ s/Ű/u/g;
  $id =~ s/Í/i/g;
  $id =~ s/ß/b/g;
  return $id;
}


1;

