#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################


package PersonPage;
use FamilyTreeBase;
@EXPORT = qw(new main);
use Params::Validate qw(:all);
use strict;
use warnings;
my $q = new CGI;

use base 'FamilyTreeBase';
sub new {
  my $type = shift;
  my $self = $type->SUPER::new(@_);
  $self->{target_person} = undef;
  return $self;
}

sub main {
  my ($self) = validate_pos(@_, {type => HASHREF});
  $self->process_parameters();
  $self->target_check();
  $self->password_check();
  $self->{imgwidth}  = 240;
  $self->{imgheight} = $self->{imgwidth} * 1.5;
  @{ $self->{peers} } = $self->{family_tree_data}->get_peers( $self->{target_person} );
  $self->draw_single_person_page( $self->{target_person} );
  $self->endpage();
}
#######################################################
# processing the parameters (type and passwd)
sub process_parameters {
  my ($self) = validate_pos(@_, {type => HASHREF});
  $self->SUPER::process_parameters();
  my $id = CGI::param("target");
  $self->{target_person} = $self->{family_tree_data}{people}{$id};
}

#######################################################
# check if target person exists in database
sub target_check {
  my ($self) = validate_pos(@_, {type => HASHREF});
  if ( !defined $self->{target_person} ) {
    my $title = $self->{textGenerator}->noDataAbout( CGI::param("target") );
    $self->toppage($title);
    print $q->br, $title, $q->br, "\n";
    $self->endpage();
    exit 1;
  }
}
sub draw_row {
    my ( $self, $key, $value) = 
    validate_pos(@_, {type => HASHREF}, {type => SCALAR}, {type => SCALAR|UNDEF});
    return unless defined $value;
    
    print $q->start_Tr,
      $q->td( $q->strong( $self->{textGenerator}->{$key} ) );
    print $q->td($value) ;      
    print $q->end_Tr, "\n";
  
}

sub draw_pictures {
  my ( $self, $the_person ) = validate_pos(@_, {type => HASHREF}, {type => SCALARREF});
  my $column_number = 3;
  my $index = 0;
  print $q->hr, $q->h3("Image gallery"),
    $q->br, $q->start_table({-align => "center"});
  foreach my $picture (@{$the_person->{pictures}}) {
    print "\n";
    print $q->start_Tr() if ( $index % $column_number == 0 );
    print $q->start_td({-width => 220}),
      $q->a({-href => $picture->{file_name}},
            $q->img({-width => 200,
               -src => $picture->{file_name},
               -alt => $picture->{comment}})), $q->br,
      $picture->{comment}, $q->end_td;
      print $q->end_Tr() if ( ($index % $column_number) == $column_number-1 );
      ++$index;
  } 
  print $q->end_Tr(),"\n" if ( ($index % $column_number) != 0 );
  print $q->br, $q->end_table(), $q->br;
}

sub draw_single_person_page {
  my ( $self, $the_person ) = validate_pos(@_, {type => HASHREF}, {type => SCALARREF});
  $self->toppage( $the_person->get_name()->get_long_name() );

  print $q->start_center;
  $self->print_zoom_buttons();
  print $self->html_img($the_person), $q->br, "\n";
  print $the_person->get_date_of_birth()->format()
    if ( defined $the_person->get_date_of_birth() );
  print " - ";
  print $the_person->get_date_of_death()->format()
    if ( defined $the_person->get_date_of_death() );
  print $q->end_center, "\n";

  print $q->br, $q->start_table( { -cellspacing => 2, -cellpadding => 2 } );
  $self->draw_row( "nickname", $the_person->get_name()->get_nickname() );
  $self->draw_row( "place_of_birth", $the_person->get_place_of_birth()->toString() )
    if(defined $the_person->get_place_of_birth());
  $self->draw_row( "place_of_death", $the_person->get_place_of_death()->toString() )
    if(defined $the_person->get_place_of_death());
  $self->draw_row( "cemetery", $the_person->get_cemetery()->toString() )
    if(defined $the_person->get_cemetery());
  $self->draw_row( "schools", join(', ', @{$the_person->get_schools()}) )
    if(defined $the_person->get_schools());
  $self->draw_row( "jobs", join(', ', @{$the_person->get_jobs()} ) )
    if(defined $the_person->get_jobs());
  $self->draw_row( "work_places", join(', ', @{$the_person->get_work_places()} ) )
    if(defined $the_person->get_work_places());
  $self->draw_row( "places_of_living", join(', ', map {$_->toString()} 
    @{$the_person->get_places_of_living()}) )
    if(defined $the_person->get_places_of_living());
  
  $self->draw_row( "father", $self->aref_tree(
    $the_person->get_father()->get_name()->get_long_name(), $the_person->get_father(), 0) )
    if ( defined $the_person->get_father() );
  $self->draw_row("mother", $self->aref_tree(
    $the_person->get_mother()->get_name()->get_long_name(), $the_person->get_mother(), 0))
    if ( defined $the_person->get_mother() );
  my $spouses_set = $self->{family_tree_data}->get_spouses(
    $self->{target_person} );
  my @spouses_set_as_array = $spouses_set->elements;
  my $spouse_type = $self->{target_person}->get_gender() == 0 ? "wives" : "husbands";
  $self->print_people_list( $spouse_type, \@spouses_set_as_array );
  $self->print_people_list( "siblings", $self->{peers} );
  
  my @peers_on_father = $self->{family_tree_data}->get_soft_peers( $self->{target_person}, "father" ); 
  $self->print_people_list( "siblings_on_father", \@peers_on_father );
  my @peers_on_mother = $self->{family_tree_data}->get_soft_peers( $self->{target_person}, "mother" ); 
  $self->print_people_list( "siblings_on_mother", \@peers_on_mother );
  $self->print_people_list( "children",
    $self->{family_tree_data}{children}{ $the_person->get_id() } );

  $self->draw_row( "email", $the_person->get_email() );
  $self->draw_row( "homepage", $the_person->get_homepage() );
  $self->draw_row( "general", $the_person->get_general() );

  print $q->end_table;
#  $self->draw_pictures($the_person)
#    if(defined $the_person->{pictures})
}

sub print_zoom_buttons {
  my ($self)     = validate_pos(@_, {type => HASHREF});
  my $lev_plus1  = 2;

  print $q->start_table(
    { -border => "0", -cellpadding => "0", -cellspacing => "2" } ), "\n",
    $q->start_Tr;
  print $q->start_td({-align => "center"}), "\n",
  $self->aref_tree($q->img( {
          -src => "$self->{graphicsUrl}/zoomout.gif",
          -alt => $self->{textGenerator}->ZoomOut($lev_plus1) }), $self->{target_person}, $lev_plus1),
      $q->end_td, $q->end_Tr, "\n",
      $q->end_table, $q->br, $q->br, "\n";
}

sub print_people_list {
  my ( $self, $people_type, $people_array_r ) = validate_pos(@_, 
    {type => HASHREF}, {type => SCALAR}, {type => ARRAYREF});
  if ( defined $people_array_r && @$people_array_r > 0) {
    print $q->start_Tr,
      $q->td( $q->strong( $self->{textGenerator}->{$people_type} ) ),
      $q->start_td;

    foreach my $person (@$people_array_r) {
      if ( $person != $self->{target_person} && $person != $self->{NONE_person}) {
        print $self->aref_tree($person->get_name()->get_full_name(), $person, 0), ", ";
      }
    }
    print $q->end_td, $q->end_Tr;
  }
}


1;

