use strict;
use warnings;
use Switch;
use CGI::Carp qw(fatalsToBrowser);

package FamilyTreeDataFactory;

sub getFamilyTree {
  my ( $config ) = @_;
  my $type = $config->{type};
  $type = "csv" if ($type eq "txt");
  
  switch ($type) {
  	case "csv" {
  	  require DataParsers::ExtendedSimonWardFormat;
  	  return ExtendedSimonWardFormat::createFamilyTreeDataFromFile($config->{config});
  	}
  	case "excel" {
  	  require DataParsers::ExcelFormat;
  	  return ExcelFormat::createFamilyTreeDataFromFile($config->{config});
  	}
    case "ser" {
      require DataParsers::SerializerFormat;
      return SerializerFormat::createFamilyTreeDataFromFile($config->{config});
    }
  	case "gedcom" {
  	  require DataParsers::GedcomFormat;
  	  return GedcomFormat::createFamilyTreeDataFromFile($config->{config});
  	  }
  	case "dbi" {
      require DataParsers::DBIFormat;
      return DBIFormat::getFamilyTreeData($config->{config});
    }
  	else {die "Unknown type: ".$type }
  }
  
}

1;
