#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################

package FamilyTreeBase;
use strict;
use warnings;
use Params::Validate qw(:all);
use CGI qw(:standard);
use FamilyTreeDataFactory;
use TextGeneratorFactory;
use SettingsFactory;
use Date::Tiny;
use CGI::Carp qw(fatalsToBrowser warningsToBrowser);

my $q = new CGI;

sub new {
  my ($classname) = @_;
  my $self = {
    version          => "2.3.6",
    family_tree_data => undef,
    lang             => undef,
    password         => undef,
    
#    treeScript       => CGI::url(-relative=>1),
    treeScript       => "ftree.cgi",
    personScript     => "person_page.cgi",
    photoUrl         => undef,
    graphicsUrl      => "../graphics",
    imgwidth         => 60,
    reqLevels        => 2,
    textGenerator    => undef,
    settings         => undef,    
  };
  $self->{imgheight}        = $self->{imgwidth} * 1.5;
  $self->{settings} = SettingsFactory::importSettings("perl");
  $self->{photoUrl} = $self->{settings}{data_source}{config}{photo_url};
  $self->{family_tree_data} =
    FamilyTreeDataFactory::getFamilyTree( $self->{settings}{data_source} );

  $self->{NONE_person} = Person->new( {id => "unknown"} );
  Date::Tiny->set_format($self->{settings}{date_format}) 
    if(defined $self->{settings}{date_format});    

  return bless $self, $classname;
}

sub process_parameters {
  my ($self) = validate_pos(@_, {type => HASHREF});
  $self->{lang} = CGI::param("lang");
  $self->{lang} = $self->{settings}{default_language} unless defined $self->{lang};
  $self->{textGenerator} =
    TextGeneratorFactory::createTextGenerator( $self->{lang} );
  Name::setReverseOrder(1)
    if(defined $self->{lang} && $self->{lang} eq "hu");
  $self->{password} = CGI::param("passwd");
  $self->{password} = "" unless defined $self->{password}; 
}

sub toppage {
  my ( $self, $title ) = validate_pos(@_, 
    {type => HASHREF}, {type => SCALAR});
  print $q->header( -charset => 'UTF-8' ),
     $q->start_html(-title=>$title,
     				-style => { -src => $self->{settings}{css_filename}},
                    -meta=>{http_equiv => 'Content-Type',
                         		content    => 'text/html',
                         		charset     =>'UTF-8'});
  warningsToBrowser(1);
  print $q->center($q->h1($title)), "\n";

}

#######################################################
# generates the html for the end of the page
sub endpage {
  my ($self) = validate_pos(@_, {type => HASHREF});
  print $q->br, $q->hr(),"\n",$q->start_strong(),
    $q->a({-href => ${self}->{treeScript}."?type=;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Relatives}), " - \n",
    $q->a({-href => ${self}->{treeScript}."?type=faces;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Faces}), " - \n",
    $q->a({-href => ${self}->{treeScript}."?type=snames;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Surnames}), " - \n",
    $q->a({-href => ${self}->{treeScript}."?type=hpages;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Homepages}), " - \n",
    $q->a({-href => ${self}->{treeScript}."?type=emails;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Emails}), " - \n",
    $q->a({-href => ${self}->{treeScript}."?type=bdays;passwd=".$self->{settings}{password}.";lang=".$self->{lang}}, 
      $self->{textGenerator}->{Birthdays}), "\n",
    $q->end_strong(), $q->br, $q->br,"\n";
  $self->languageChooser();

  print "\n",'<script src="http://www.google-analytics.com/urchin.js" type="text/javascript">',
      '</script>',
      '<script type="text/javascript">',
      '_uacct = "UA-1237567-1";',
      'urchinTracker();',
      '</script>', "\n";
  print $q->start_i, $self->{textGenerator}->maintainer( $self->{settings}{adminName}, 
    $self->{settings}{adminEmail},  $self->{settings}{adminHomepage} ), $q->br,
    $self->{textGenerator}->software($self->{version}), "\n",
    $q->end_i, $q->br;
  print $q->i($self->{textGenerator}{DonationSentence}),
  '<form action="https://www.paypal.com/cgi-bin/webscr" method="post">
<input type="hidden" name="cmd" value="_s-xclick">
<input type="image" src="https://www.paypal.com/en_US/i/btn/x-click-but04.gif" border="0" name="submit" alt="Make payments with PayPal - it is fast, free and secure!">
<img alt="" border="0" src="https://www.paypal.com/en_US/i/scr/pixel.gif" width="1" height="1">
<input type="hidden" name="encrypted" value="-----BEGIN PKCS7-----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-----END PKCS7-----
">
</form>';
  if ( $self->{settings}{sitemeter_needed} ) {
    print "<!--WEBBOT bot=\"HTMLMarkup\" startspan ALT=\"Site Meter\" -->\n",
      "<script type=\"text/javascript\" language=\"JavaScript\">var site=\"$self->{settings}{sitemeter_id}\"</script>\n",
      "<script type=\"text/javascript\" language=\"JavaScript1.2\" src=\"http://s22.sitemeter.com/js/counter.js?site=$self->{settings}{sitemeter_id}\">\n",
      "</script>\n",
      "<noscript>\n",
      "<a href=\"http://s22.sitemeter.com/stats.asp?site=$self->{settings}{sitemeter_id}\" target=\"_top\">\n",
      "<img src=\"http://s22.sitemeter.com/meter.asp?site=$self->{settings}{sitemeter_id}\" alt=\"Site Meter\" border=\"0\"/></a>\n",
      "</noscript>\n",
      "<!-- Copyright (c)2005 Site Meter -->\n",
      "<!--WEBBOT bot=\"HTMLMarkup\" Endspan -->\n";
  }
  print $q->end_html;
}

#########################################################
# check password
sub password_check {
  my ($self) = validate_pos(@_, {type => HASHREF});
  if ( $self->{settings}{passwordReq} ne ""
    && $self->{settings}{password} ne $self->{password} )
  {
    $self->toppage( $self->{textGenerator}->{Error} );
    printf "<br>\n<br/>\n" . $self->{textGenerator}->{Sorry} . "!<br><br>\n";
    if ( $self->{settings}{password} eq "" ) {
      print $self->{textGenerator}->{Passwd_need};
    }
    else {
      print "You have given the wrong password for these pages.";
    }

    print "<br><form action=\"$self->{treeScript}\" method=\"GET\">",
      "<input type=\"hidden\" name=\"type\" value=\"$self->{pagetype}\">",
      "<p><strong>$self->{settings}{passwordPrompt}</strong><br>",
      "<input type=\"text\" size=\"25\" name=\"passwd\">",
      " <input type=\"submit\" value=\"Go\"></p>",
      "</form>\n";
    $self->endpage();
    exit 1;
  }
}

  sub getCellClass {
    my ( $self, $person, $nr_of_man, $nr_of_woman ) = validate_pos(@_, 
      {type => HASHREF}, {type => SCALARREF}, {type => SCALARREF}, {type => SCALARREF});
    if ( !defined $person->get_gender() ) {
      return "unknown";
    }
    elsif ( $person->get_gender() == 0 ) {
      ++$$nr_of_man;
      return "man";
    }
    else {
      ++$$nr_of_woman;
      return "woman";
    }
  }
  
  sub languageChooser {
    #I guess this function can be done simpler!
    my ( $self) = validate_pos(@_, {type => HASHREF});
    my $anchor= $q->url(-relative=>0)."?";
    my %params = CGI::Vars();
    while( my ($key, $value) = each %params) {
      if($key ne "lang") {
        $anchor .= $key."=".$value.";";
      }
      
    }
    print "\n", $q->start_table({-cellpadding => '3'}),"\n", $q->start_Tr;
    my %langToPict = TextGeneratorFactory::getLangToPict();
    while ( my ($lang, $pic) = each(%langToPict) ) {
      print $q->td({-align => "center"}, 
        $q->a({-href => "${anchor}lang=".$pic,
               -title => $self->{textGenerator}->{$lang} },
          $q->img({-width => 40, -src =>"$self->{graphicsUrl}/flags/".$pic.".gif", 
               -alt =>$self->{textGenerator}->{$lang}}))),"\n",
    }
    print $q->end_Tr, "\n", $q->end_table, $q->br,"\n";
  }
  
  sub html_img {
  my ( $self, $person ) = validate_pos(@_, 
      {type => HASHREF}, {type => SCALARREF});
  if ( !defined $person ) {
    return "";
  }
  else {
    my $picture_file = defined $person->get_default_picture() ?
     $self->{photoUrl} . $person->get_default_picture()->get_file_name() :
     $self->{graphicsUrl} . "/nophoto.gif";
    return $q->img(
      {
        -border => "2",
        -src    => $picture_file,
        -alt    => (defined $person->get_name()) ? $person->get_name()->get_full_name() : "UNKNOWN",
        -width  => $self->{imgwidth},
        -height => $self->{imgheight}
      }
    );
  }
}
  
  
  sub aref_tree {
  my ( $self, $to_ref, $person, $levels ) = validate_pos(@_, 
      {type => HASHREF}, {type => SCALAR}, {type => SCALARREF}, {optional => 1, type => SCALAR});
  if(!defined $levels) {
    $levels = $self->{reqLevels};
    $person = $self->$self->{target_person} unless(defined $person);
  } 
  if($levels > 0) {
    return $q->a(
        {
          -href => "$self->{treeScript}?type=tree;"
            ."target=" . $person->get_id() . ";levels=$levels;"
            ."passwd=$self->{settings}{password};lang=$self->{lang}",
          -title => $self->brief_info($person)            
        }, $to_ref);
  }
  else {
    return $q->a(
        {
          -href => "$self->{personScript}?target=" . $person->get_id()
            . ";passwd=$self->{settings}{password};lang=$self->{lang}",
          -title => $self->brief_info($person)            
        }, $to_ref);
    }  
  }
  
sub brief_info {
  my ( $self, $person ) = validate_pos(@_, 
      {type => HASHREF}, {type => SCALARREF});
  my $brief_info;
  $brief_info .= $self->{textGenerator}{father}.": ".$person->get_father()->get_name()->get_long_name()." "
    if(defined $person->get_father() && defined $person->get_father()->get_name());
  $brief_info .= $self->{textGenerator}{mother}.": ".$person->get_mother()->get_name()->get_long_name()." "
    if(defined $person->get_mother() && defined $person->get_mother()->get_name());
  $brief_info .= $self->{textGenerator}{date_of_birth}.": ".$person->get_date_of_birth()->format()." "
    if(defined $person->get_date_of_birth());
	$brief_info .= $self->{textGenerator}{date_of_death}.": ".$person->get_date_of_death()->format()." "
	 if(defined $person->get_date_of_death());
	return $brief_info;
}
      
1;
