#######################################################
#
# Family Tree generation program, v2.0
# Written by Ferenc Bodon and Simon Ward, March 2000 (simonward.com)
# Copyright (C) 2000 Ferenc Bodon, Simon K Ward
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# For a copy of the GNU General Public License, visit 
# http://www.gnu.org or write to the Free Software Foundation, Inc.,
# 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
#######################################################


package ExcelFormat;
use StringUtils;
use Spreadsheet::ParseExcel;
use DataParsers::ExtendedSimonWardFormat; # for getting pictures. Temporal solution
use FamilyTreeData;
use CGI::Carp qw(fatalsToBrowser);

sub createFamilyTreeDataFromFile {
  my ($config_) = @_;
  my $file_name = $config_->{file_name} or die "No file_name is given in config";
    
  my $family_tree_data = FamilyTreeData->new();
  my $excel = Spreadsheet::ParseExcel::Workbook->Parse($file_name)
    or die "Unable to parse file " . $file_name;
  foreach my $sheet (@{$excel->{Worksheet}}) {
    $sheet->{MaxRow} ||= $sheet->{MinRow};
    foreach my $row ($sheet->{MinRow}+1 .. $sheet->{MaxRow}) {
        $family_tree_data->add_person({
          id => $sheet->{Cells}[$row][0]->{Val},
          first_name => $sheet->{Cells}[$row][3]->{Val},
          mid_name   => $sheet->{Cells}[$row][4]->{Val},
          last_name  => $sheet->{Cells}[$row][5]->{Val},
          title      => $sheet->{Cells}[$row][1]->{Val},
          prefix     => $sheet->{Cells}[$row][2]->{Val},
          suffix     => $sheet->{Cells}[$row][6]->{Val},
          nickname   => $sheet->{Cells}[$row][7]->{Val},
          father_id  => $sheet->{Cells}[$row][8]->{Val},
          mother_id  => $sheet->{Cells}[$row][9]->{Val},
          email      => $sheet->{Cells}[$row][10]->{Val},
          homepage   => $sheet->{Cells}[$row][11]->{Val},
          date_of_birth => $sheet->{Cells}[$row][12]->{Val},          
          date_of_death => $sheet->{Cells}[$row][13]->{Val},
          gender     => $sheet->{Cells}[$row][14]->{Val},
          is_living  => $sheet->{Cells}[$row][15]->{Val},
          place_of_birth => $sheet->{Cells}[$row][16]->{Val},
          place_of_death => $sheet->{Cells}[$row][17]->{Val},
          cemetery   => $sheet->{Cells}[$row][18]->{Val},
          schools    => (defined $sheet->{Cells}[$row][19]->{Val}) ?
            [split( /,/, $sheet->{Cells}[$row][19]->{Val})] : undef,
          jobs       => (defined $sheet->{Cells}[$row][20]->{Val}) ?
            [split( /,/, $sheet->{Cells}[$row][20]->{Val})] : undef,
          work_places => (defined $sheet->{Cells}[$row][21]->{Val}) ? 
            [split( /,/, $sheet->{Cells}[$row][21]->{Val} )] : undef,
          places_of_living => $sheet->{Cells}[$row][22]->{Val},
          general    => $sheet->{Cells}[$row][23]->{Val} });
    }
  }
  if (defined $config_->{photo_dir}) {
    ExtendedSimonWardFormat::setPictureDirectory($config_->{photo_dir});
    ExtendedSimonWardFormat::fill_up_pictures($family_tree_data);
  }
  
  return $family_tree_data;
}
1;
